/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.bills;

public class BillPaymentByCardRequest {
    final String pinType = "EPAY";
    final String pan;
    final String pin;
    final String cvv2;
    final String expDate;
    final String billId;
    final String payId;
    final String merchantId;
    final boolean requireVerification;
    final Long verificationExpirationTimeOut;

    private BillPaymentByCardRequest(String pan, String pin, String cvv2, String expDate, String billId, String payId, String merchantId, boolean requireVerification, Long verificationExpirationTimeOut) {
        this.panNotEmpty(pan);
        this.pinNotEmpty(pin);
        this.cvv2NotEmpty(cvv2);
        this.expDateNotEmpty(expDate);
        this.billIdNotEmpty(billId);
        this.payIdNotEmpty(payId);
        this.verificationExpirationTimeOutNotNegative(verificationExpirationTimeOut);
        this.pan = pan;
        this.pin = pin;
        this.cvv2 = cvv2;
        this.expDate = expDate;
        this.billId = billId;
        this.payId = payId;
        this.merchantId = merchantId;
        this.requireVerification = requireVerification;
        this.verificationExpirationTimeOut = verificationExpirationTimeOut;
    }

    private void billIdNotEmpty(String billId) {
        if (billId == null || billId.trim().isEmpty()) {
            throw new IllegalArgumentException("BillId can't be a blank string");
        }
    }

    private void payIdNotEmpty(String payId) {
        if (payId == null || payId.trim().isEmpty()) {
            throw new IllegalArgumentException("PayId can't be a blank string");
        }
    }

    private void expDateNotEmpty(String expDate) {
        if (expDate == null || expDate.trim().isEmpty()) {
            throw new IllegalArgumentException("Expire date can't be a blank string");
        }
    }

    private void cvv2NotEmpty(String cvv2) {
        if (cvv2 == null || cvv2.trim().isEmpty()) {
            throw new IllegalArgumentException("Cvv2 can't be a blank string");
        }
    }

    private void pinNotEmpty(String pin) {
        if (pin == null || pin.trim().isEmpty()) {
            throw new IllegalArgumentException("Pin can't be a blank string");
        }
    }

    private void panNotEmpty(String pan) {
        if (pan == null || pan.trim().isEmpty()) {
            throw new IllegalArgumentException("Pan can't be a blank string");
        }
    }

    private void verificationExpirationTimeOutNotNegative(Long verificationExpirationTimeOut) {
        if (verificationExpirationTimeOut != null && verificationExpirationTimeOut <= 0L) {
            throw new IllegalArgumentException("Verification time can't be negative");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String pan;
        private String pin;
        private String cvv2;
        private String expDate;
        private String billId;
        private String payId;
        private String merchantId;
        private boolean requireVerification;
        private Long verificationExpirationTimeOut;

        public Builder withPan(String pan) {
            this.pan = pan;
            return this;
        }

        public Builder withPin(String pin) {
            this.pin = pin;
            return this;
        }

        public Builder withCvv2(String cvv2) {
            this.cvv2 = cvv2;
            return this;
        }

        public Builder withExpDate(String expDate) {
            this.expDate = expDate;
            return this;
        }

        public Builder withBillId(String billId) {
            this.billId = billId;
            return this;
        }

        public Builder withPayId(String payId) {
            this.payId = payId;
            return this;
        }

        public Builder withMerchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder withRequireVerification(boolean requireVerification) {
            this.requireVerification = requireVerification;
            return this;
        }

        public Builder withVerificationExpirationTimeOut(Long verificationExpirationTimeOut) {
            this.verificationExpirationTimeOut = verificationExpirationTimeOut;
            return this;
        }

        public BillPaymentByCardRequest build() {
            return new BillPaymentByCardRequest(this.pan, this.pin, this.cvv2, this.expDate, this.billId, this.payId, this.merchantId, this.requireVerification, this.verificationExpirationTimeOut);
        }
    }
}

