/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.ach;

import java.math.BigDecimal;
import java.util.Date;

public class AchTransactionReportRequest {
    final String sourceDepositIban;
    final String transferDescription;
    final Long offset;
    final Long length;
    final String referenceId;
    final String transactionId;
    final Date fromRegisterDate;
    final Date toRegisterDate;
    final Date fromIssueDate;
    final Date toIssueDate;
    final BigDecimal fromTransactionAmount;
    final BigDecimal toTransactionAmount;
    final String ibanNumber;
    final String ibanOwnerName;
    final String factorNumber;
    final String description;

    private AchTransactionReportRequest(String sourceDepositIban, String transferDescription, Long offset, Long length, String referenceId, String transactionId, Date fromRegisterDate, Date toRegisterDate, Date fromIssueDate, Date toIssueDate, BigDecimal fromTransactionAmount, BigDecimal toTransactionAmount, String ibanNumber, String ibanOwnerName, String factorNumber, String description) {
        this.assertPaginationParams(length, offset);
        this.assertAmountFilters(fromTransactionAmount, toTransactionAmount);
        this.assertTimeSpanFilters(fromRegisterDate, toRegisterDate);
        this.assertTimeSpanFilters(fromIssueDate, toIssueDate);
        this.sourceDepositIban = sourceDepositIban;
        this.transferDescription = transferDescription;
        this.offset = offset;
        this.length = length;
        this.referenceId = referenceId;
        this.transactionId = transactionId;
        this.fromRegisterDate = fromRegisterDate;
        this.toRegisterDate = toRegisterDate;
        this.fromIssueDate = fromIssueDate;
        this.toIssueDate = toIssueDate;
        this.fromTransactionAmount = fromTransactionAmount;
        this.toTransactionAmount = toTransactionAmount;
        this.ibanNumber = ibanNumber;
        this.ibanOwnerName = ibanOwnerName;
        this.factorNumber = factorNumber;
        this.description = description;
    }

    private void assertTimeSpanFilters(Date fromDate, Date toDate) {
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            throw new IllegalArgumentException("From date can't be after to date");
        }
    }

    private void assertAmountFilters(BigDecimal fromTransactionAmount, BigDecimal toTransactionAmount) {
        if (fromTransactionAmount != null && fromTransactionAmount.signum() < 0) {
            throw new IllegalArgumentException("From amount can't be negative value");
        }
        if (toTransactionAmount != null && toTransactionAmount.signum() < 0) {
            throw new IllegalArgumentException("To amount can't be negative value");
        }
        if (fromTransactionAmount != null && toTransactionAmount != null && fromTransactionAmount.compareTo(toTransactionAmount) > 0) {
            throw new IllegalArgumentException("From amount can't be bigger than to amount");
        }
    }

    private void assertPaginationParams(Long length, Long offset) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("Length can't be less than or equal to zero");
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("Offset can't be a negative value");
        }
    }

    public static AchTransactionReportRequest withoutFilter() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String sourceDepositIban;
        private String transferDescription;
        private Long offset;
        private Long length;
        private String referenceId;
        private String transactionId;
        private Date fromRegisterDate;
        private Date toRegisterDate;
        private Date fromIssueDate;
        private Date toIssueDate;
        private BigDecimal fromTransactionAmount;
        private BigDecimal toTransactionAmount;
        private String ibanNumber;
        private String ibanOwnerName;
        private String factorNumber;
        private String description;

        public Builder withSourceDepositIban(String sourceDepositIban) {
            this.sourceDepositIban = sourceDepositIban;
            return this;
        }

        public Builder withTransferDescription(String transferDescription) {
            this.transferDescription = transferDescription;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public Builder withReferenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder withTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder withFromTransactionAmount(BigDecimal fromTransactionAmount) {
            this.fromTransactionAmount = fromTransactionAmount;
            return this;
        }

        public Builder withToTransactionAmount(BigDecimal toTransactionAmount) {
            this.toTransactionAmount = toTransactionAmount;
            return this;
        }

        public Builder withIbanNumber(String ibanNumber) {
            this.ibanNumber = ibanNumber;
            return this;
        }

        public Builder withIbanOwnerName(String ibanOwnerName) {
            this.ibanOwnerName = ibanOwnerName;
            return this;
        }

        public Builder withFromRegisterDate(Date fromRegisterDate) {
            this.fromRegisterDate = fromRegisterDate;
            return this;
        }

        public Builder withToRegisterDate(Date toRegisterDate) {
            this.toRegisterDate = toRegisterDate;
            return this;
        }

        public Builder withFromIssueDate(Date fromIssueDate) {
            this.fromIssueDate = fromIssueDate;
            return this;
        }

        public Builder withToIssueDate(Date toIssueDate) {
            this.toIssueDate = toIssueDate;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withFactorNumber(String factorNumber) {
            this.factorNumber = factorNumber;
            return this;
        }

        public AchTransactionReportRequest build() {
            return new AchTransactionReportRequest(this.sourceDepositIban, this.transferDescription, this.offset, this.length, this.referenceId, this.transactionId, this.fromRegisterDate, this.toRegisterDate, this.fromIssueDate, this.toIssueDate, this.fromTransactionAmount, this.toTransactionAmount, this.ibanNumber, this.ibanOwnerName, this.factorNumber, this.description);
        }
    }
}

