/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.ach;

import ir.boommarket.Asserts;
import java.math.BigDecimal;

public class AchNormalTransferRequest {
    final String sourceDepositNumber;
    final String ibanNumber;
    final String ownerName;
    final BigDecimal amount;
    final String description;
    final String transferDescription;
    final String factorNumber;

    private AchNormalTransferRequest(String transferDescription, String sourceDepositNumber, String ibanNumber, String ownerName, String description, BigDecimal amount, String factorNumber) {
        this.assertRequiredParams(sourceDepositNumber, ibanNumber, ownerName);
        this.assertAmountLimitation(amount);
        this.transferDescription = transferDescription;
        this.sourceDepositNumber = sourceDepositNumber;
        this.ibanNumber = ibanNumber;
        this.ownerName = ownerName;
        this.description = description;
        this.amount = amount;
        this.factorNumber = factorNumber;
    }

    private void assertRequiredParams(String sourceDepositNumber, String ibanNumber, String ownerName) {
        Asserts.notBlank(sourceDepositNumber, "Source deposit number can't be a blank string");
        Asserts.notBlank(ibanNumber, "Iban number can't be a blank string");
        Asserts.notBlank(ownerName, "Owner name can't be a blank string");
    }

    private void assertAmountLimitation(BigDecimal amount) {
        if (amount == null || amount.signum() <= 0) {
            throw new IllegalArgumentException("Amount can't be null or negative");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String transferDescription;
        private String sourceDepositNumber;
        private String ibanNumber;
        private String ownerName;
        private String description;
        private BigDecimal amount;
        private String factorNumber;

        public Builder withTransferDescription(String transferDescription) {
            this.transferDescription = transferDescription;
            return this;
        }

        public Builder withSourceDepositNumber(String sourceDepositNumber) {
            this.sourceDepositNumber = sourceDepositNumber;
            return this;
        }

        public Builder withIbanNumber(String ibanNumber) {
            this.ibanNumber = ibanNumber;
            return this;
        }

        public Builder withOwnerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder withFactorNumber(String factorNumber) {
            this.factorNumber = factorNumber;
            return this;
        }

        public AchNormalTransferRequest build() {
            return new AchNormalTransferRequest(this.transferDescription, this.sourceDepositNumber, this.ibanNumber, this.ownerName, this.description, this.amount, this.factorNumber);
        }
    }
}

