/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.ach;

import ir.boommarket.Asserts;
import ir.boommarket.ach.AchDestinationTransaction;
import java.util.List;

public class AchBatchTransferRequest {
    final String sourceDepositNumber;
    final List<AchDestinationTransaction> transactions;
    final String transferDescription;
    final boolean ignoreError;

    public AchBatchTransferRequest(String sourceDepositNumber, List<AchDestinationTransaction> transactions, String transferDescription, boolean ignoreError) {
        Asserts.notBlank(sourceDepositNumber, "Source deposit number can't be a blank string");
        Asserts.notEmpty(transactions, "List of transaction can't be empty");
        this.sourceDepositNumber = sourceDepositNumber;
        this.transactions = transactions;
        this.transferDescription = transferDescription;
        this.ignoreError = ignoreError;
    }

    public AchBatchTransferRequest(String sourceDepositNumber, List<AchDestinationTransaction> transactions) {
        this(sourceDepositNumber, transactions, null, true);
    }

    public AchBatchTransferRequest(String sourceDepositNumber, List<AchDestinationTransaction> transactions, String transferDescription) {
        this(sourceDepositNumber, transactions, transferDescription, true);
    }

    public AchBatchTransferRequest(String sourceDepositNumber, List<AchDestinationTransaction> transactions, boolean ignoreError) {
        this(sourceDepositNumber, transactions, null, ignoreError);
    }
}

