/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.ach;

import ir.boommarket.Asserts;
import ir.boommarket.ach.AchAutoTransactionPeriod;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class AchAutoTransferRequest {
    final String sourceDepositNumber;
    final String ibanNumber;
    final String ownerName;
    final BigDecimal amount;
    final String transferDescription;
    final Date confirmExpireDate;
    final String description;
    final List<AchAutoTransactionPeriod> periods;

    private AchAutoTransferRequest(String sourceDepositNumber, String ibanNumber, String ownerName, BigDecimal amount, String transferDescription, Date confirmExpireDate, String description, List<AchAutoTransactionPeriod> periods) {
        this.assertRequiredParams(sourceDepositNumber, ibanNumber, ownerName);
        this.assertAmountLimitation(amount);
        Asserts.notEmpty(periods, "Periods of transaction list can't be empty");
        this.sourceDepositNumber = sourceDepositNumber;
        this.ibanNumber = ibanNumber;
        this.ownerName = ownerName;
        this.amount = amount;
        this.transferDescription = transferDescription;
        this.confirmExpireDate = confirmExpireDate;
        this.description = description;
        this.periods = periods;
    }

    private void assertRequiredParams(String sourceDepositNumber, String ibanNumber, String ownerName) {
        Asserts.notBlank(sourceDepositNumber, "Source deposit number can't be a blank string");
        Asserts.notBlank(ibanNumber, "Iban number can't be a blank string");
        Asserts.notBlank(ownerName, "Owner name can't be a blank string");
    }

    private void assertAmountLimitation(BigDecimal amount) {
        if (amount == null || amount.signum() <= 0) {
            throw new IllegalArgumentException("Amount can't be null or negative");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String sourceDepositNumber;
        private String ibanNumber;
        private String ownerName;
        private BigDecimal amount;
        private String transferDescription;
        private Date confirmExpireDate;
        private String description;
        private List<AchAutoTransactionPeriod> periods;

        public Builder withSourceDepositNumber(String sourceDepositNumber) {
            this.sourceDepositNumber = sourceDepositNumber;
            return this;
        }

        public Builder withIbanNumber(String ibanNumber) {
            this.ibanNumber = ibanNumber;
            return this;
        }

        public Builder withOwnerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public Builder withAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder withTransferDescription(String transferDescription) {
            this.transferDescription = transferDescription;
            return this;
        }

        public Builder withConfirmExpireDate(Date confirmExpireDate) {
            this.confirmExpireDate = confirmExpireDate;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withPeriods(List<AchAutoTransactionPeriod> periods) {
            this.periods = periods;
            return this;
        }

        public AchAutoTransferRequest build() {
            return new AchAutoTransferRequest(this.sourceDepositNumber, this.ibanNumber, this.ownerName, this.amount, this.transferDescription, this.confirmExpireDate, this.description, this.periods);
        }
    }
}

