/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket;

import ir.boommarket.BoomApi;
import ir.boommarket.ErrorResponse;
import ir.boommarket.FailedRequestException;
import ir.boommarket.HttpClient;
import ir.boommarket.Json;
import ir.boommarket.RestApiException;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;

public class Requests {
    private static final String SANDBOX_HEADER = "Sandbox";
    private static final String BANK_HEADER = "Bank-Id";
    private static final String SESSION_HEADER = "Session";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String APP_KEY_HEADER = "App-Key";
    private static final String TOKEN_HEADER = "Token-Id";
    private static final String DEVICE_ID_HEADER = "Device-Id";
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";

    public static Request.Builder withCommonHeaders(Request.Builder builder, BoomApi boomApi) {
        if (boomApi == null) {
            return builder;
        }
        builder.header(SANDBOX_HEADER, boomApi.isSandbox() + "");
        if (boomApi.bank() != null) {
            builder.header(BANK_HEADER, boomApi.bank().swiftCode());
        }
        if (Requests.notBlank(boomApi.session())) {
            builder.header(SESSION_HEADER, boomApi.session());
        }
        if (Requests.notBlank(boomApi.accessToken())) {
            builder.header(AUTHORIZATION_HEADER, "Bearer " + boomApi.accessToken());
        }
        if (Requests.notBlank(boomApi.appKey())) {
            builder.header(APP_KEY_HEADER, boomApi.appKey());
        }
        if (Requests.notBlank(boomApi.boomToken())) {
            builder.header(TOKEN_HEADER, boomApi.boomToken());
        }
        if (Requests.notBlank(boomApi.deviceId())) {
            builder.header(DEVICE_ID_HEADER, boomApi.deviceId());
        }
        if (boomApi.language() != null) {
            builder.header(ACCEPT_LANGUAGE_HEADER, boomApi.language().locale());
        }
        return builder;
    }

    public static <T> T sendRequest(Request request, Class<T> clazz) {
        try {
            Response response = HttpClient.getInstance().newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                return Json.read(responseBody, clazz);
            }
            ErrorResponse errorResponse = Json.read(responseBody, ErrorResponse.class);
            throw new RestApiException(errorResponse);
        }
        catch (IOException e) {
            throw new FailedRequestException("Couldn't send the http request", e);
        }
    }

    private static boolean notBlank(String whatever) {
        return whatever != null && !whatever.trim().isEmpty();
    }
}

