/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.deposits;

import ir.boommarket.deposits.DepositStatus;
import java.util.List;

public class DepositListRequest {
    final List<String> depositNumbers;
    final DepositStatus depositStatus;
    final boolean includeSupportAccount;
    final boolean includeCreditAccount;
    final Long offset;
    final Long length;

    private DepositListRequest(List<String> depositNumbers, DepositStatus depositStatus, boolean includeSupportAccount, boolean includeCreditAccount, Long offset, Long length) {
        this.offsetNotNegative(offset);
        this.lengthNotNegative(length);
        this.depositNumbers = depositNumbers;
        this.depositStatus = depositStatus;
        this.includeSupportAccount = includeSupportAccount;
        this.includeCreditAccount = includeCreditAccount;
        this.offset = offset;
        this.length = length;
    }

    public static DepositListRequest withoutFilter() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void offsetNotNegative(Long offset) {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset can't be a negative number");
        }
    }

    private void lengthNotNegative(Long length) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("length can't be less than or equal to zero");
        }
    }

    public static class Builder {
        private List<String> depositNumbers;
        private DepositStatus depositStatus;
        private boolean includeSupportAccount;
        private boolean includeCreditAccount;
        private Long offset;
        private Long length;

        public Builder withDepositNumbers(List<String> depositNumbers) {
            this.depositNumbers = depositNumbers;
            return this;
        }

        public Builder withDepositStatus(DepositStatus depositStatus) {
            this.depositStatus = depositStatus;
            return this;
        }

        public Builder withIncludeSupportAccount(Boolean includeSupportAccount) {
            this.includeSupportAccount = includeSupportAccount;
            return this;
        }

        public Builder withIncludeCreditAccount(Boolean includeCreditAccount) {
            this.includeCreditAccount = includeCreditAccount;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public DepositListRequest build() {
            return new DepositListRequest(this.depositNumbers, this.depositStatus, this.includeSupportAccount, this.includeCreditAccount, this.offset, this.length);
        }
    }
}

