/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.cards;

import ir.boommarket.Asserts;
import ir.boommarket.cards.TransactionType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ListTransactionsRequest {
    final String pinType = "EPAY";
    final String pan;
    final String pin;
    final String cvv2;
    final String expDate;
    final Date fromDate;
    final Date toDate;
    final String destinationPan;
    final BigDecimal fromAmount;
    final BigDecimal toAmount;
    final Set<TransactionType> transactionTypes;
    final Long length;
    final Long offset;

    private ListTransactionsRequest(String pan, String pin, String cvv2, String expDate, Date fromDate, Date toDate, String destinationPan, BigDecimal fromAmount, BigDecimal toAmount, Set<TransactionType> transactionTypes, Long length, Long offset) {
        this.assertRequiredParams(pan, pin, cvv2, expDate, fromDate);
        this.assertTimeSpanFilters(fromDate, toDate);
        this.assertAmountFilters(fromAmount, toAmount);
        this.assertPaginationParams(length, offset);
        this.pan = pan;
        this.pin = pin;
        this.cvv2 = cvv2;
        this.expDate = expDate;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.destinationPan = destinationPan;
        this.fromAmount = fromAmount;
        this.toAmount = toAmount;
        this.transactionTypes = transactionTypes;
        this.length = length;
        this.offset = offset;
    }

    private void assertRequiredParams(String pan, String pin, String cvv2, String expDate, Date fromDate) {
        Asserts.notBlank(pan, "Pan (Card Number) can't be blank string");
        Asserts.notBlank(pin, "Pin (Card Password) can't be a blank string");
        Asserts.notBlank(cvv2, "CVV2 can't be a blank string");
        Asserts.notBlank(expDate, "Expiration date can't be a blank string");
        Asserts.notNull(fromDate, "From date can't be null");
    }

    private void assertTimeSpanFilters(Date fromDate, Date toDate) {
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            throw new IllegalArgumentException("fromDate can't be after toDate");
        }
    }

    private void assertAmountFilters(BigDecimal fromAmount, BigDecimal toAmount) {
        if (fromAmount != null && fromAmount.signum() < 0) {
            throw new IllegalArgumentException("fromAmount can't be negative value");
        }
        if (toAmount != null && toAmount.signum() < 0) {
            throw new IllegalArgumentException("toAmount can't be negative value");
        }
        if (fromAmount != null && toAmount != null && fromAmount.compareTo(toAmount) > 0) {
            throw new IllegalArgumentException("fromAmount can't be bigger than toAmount");
        }
    }

    private void assertPaginationParams(Long length, Long offset) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("Length can't be less than or equal to zero");
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("Offset can't be a negative value");
        }
    }

    public static Builder forPan(String pan) {
        return new Builder().withPan(pan);
    }

    public static class Builder {
        private String pan;
        private String pin;
        private String cvv2;
        private String expDate;
        private Date fromDate;
        private Date toDate;
        private String destinationPan;
        private BigDecimal fromAmount;
        private BigDecimal toAmount;
        private Set<TransactionType> transactionTypes;
        private Long length;
        private Long offset;

        public Builder withPan(String pan) {
            this.pan = pan;
            return this;
        }

        public Builder withPin(String pin) {
            this.pin = pin;
            return this;
        }

        public Builder withCvv2(String cvv2) {
            this.cvv2 = cvv2;
            return this;
        }

        public Builder expiresIn(String expDate) {
            this.expDate = expDate;
            return this;
        }

        public Builder fromDate(Date date) {
            this.fromDate = date;
            return this;
        }

        public Builder toDate(Date date) {
            this.toDate = date;
            return this;
        }

        public Builder withDestinationPan(String destinationPan) {
            this.destinationPan = destinationPan;
            return this;
        }

        public Builder fromAmount(BigDecimal fromAmount) {
            this.fromAmount = fromAmount;
            return this;
        }

        public Builder toAmount(BigDecimal toAmount) {
            this.toAmount = toAmount;
            return this;
        }

        public Builder addTransactionType(TransactionType type) {
            if (type != null) {
                if (this.transactionTypes == null) {
                    this.transactionTypes = new HashSet<TransactionType>();
                }
                this.transactionTypes.add(type);
            }
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public ListTransactionsRequest build() {
            return new ListTransactionsRequest(this.pan, this.pin, this.cvv2, this.expDate, this.fromDate, this.toDate, this.destinationPan, this.fromAmount, this.toAmount, this.transactionTypes, this.length, this.offset);
        }
    }
}

