/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.bills;

import ir.boommarket.Asserts;
import ir.boommarket.BoomApi;
import ir.boommarket.Json;
import ir.boommarket.Requests;
import ir.boommarket.bills.BillInfo;
import ir.boommarket.bills.BillInfoRequest;
import ir.boommarket.bills.BillPayment;
import ir.boommarket.bills.BillPaymentByCardRequest;
import ir.boommarket.bills.BillPaymentByDepositRequest;
import okhttp3.Request;

public class Bills {
    public static BillInfo getBillInfo(BillInfoRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be null");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "bills/" + request.billId + "/payments/" + request.payId;
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).get().build();
        return Requests.sendRequest(httpRequest, BillInfo.class);
    }

    public static BillPayment payBillByDeposit(BillPaymentByDepositRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be null");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "bills/" + request.billId + "/payments/" + request.payId + "/deposit";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, BillPayment.class);
    }

    public static BillPayment payBillByCard(BillPaymentByCardRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be null");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "bills/" + request.billId + "/payments/" + request.payId + "/card";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, BillPayment.class);
    }
}

