/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.bills;

import ir.boommarket.Asserts;

public class BillPaymentByDepositRequest {
    final String billId;
    final String payId;
    final String depositNumber;
    final String customerNumber;
    final boolean requireVerification;
    final Long verificationExpirationTimeOut;

    private BillPaymentByDepositRequest(String billId, String payId, String customerNumber, String depositNumber, boolean requireVerification, Long verificationExpirationTimeOut) {
        this.assertRequiredParams(billId, payId, depositNumber);
        this.verificationExpirationTimeOutNotNegative(verificationExpirationTimeOut);
        this.billId = billId;
        this.payId = payId;
        this.depositNumber = depositNumber;
        this.customerNumber = customerNumber;
        this.requireVerification = requireVerification;
        this.verificationExpirationTimeOut = verificationExpirationTimeOut;
    }

    private void assertRequiredParams(String billId, String payId, String depositNumber) {
        Asserts.notBlank(billId, "Bill Id can't be a blank string");
        Asserts.notBlank(payId, "Pay Id can't be a blank string");
        Asserts.notBlank(depositNumber, "Deposit number can't be a blank string");
    }

    private void verificationExpirationTimeOutNotNegative(Long verificationExpirationTimeOut) {
        if (verificationExpirationTimeOut != null && verificationExpirationTimeOut <= 0L) {
            throw new IllegalArgumentException("Verification time can't be negative");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String billId;
        private String payId;
        private String customerNumber;
        private String depositNumber;
        private boolean requireVerification;
        private Long verificationExpirationTimeOut;

        public Builder withBillId(String billId) {
            this.billId = billId;
            return this;
        }

        public Builder withPayId(String payId) {
            this.payId = payId;
            return this;
        }

        public Builder withCustomerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            return this;
        }

        public Builder withDepositNumber(String depositNumber) {
            this.depositNumber = depositNumber;
            return this;
        }

        public Builder withRequireVerification(boolean requireVerification) {
            this.requireVerification = requireVerification;
            return this;
        }

        public Builder withVerificationExpirationTimeOut(Long verificationExpirationTimeOut) {
            this.verificationExpirationTimeOut = verificationExpirationTimeOut;
            return this;
        }

        public BillPaymentByDepositRequest build() {
            return new BillPaymentByDepositRequest(this.billId, this.payId, this.customerNumber, this.depositNumber, this.requireVerification, this.verificationExpirationTimeOut);
        }
    }
}

