/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.banks;

import ir.boommarket.Asserts;
import ir.boommarket.Bank;
import ir.boommarket.QueryParams;

public class BranchListRequest {
    final Bank bank;
    Long length;
    Long offset;

    public BranchListRequest(Bank bank) {
        this(bank, null, null);
    }

    public BranchListRequest(Bank bank, Long length, Long offset) {
        Asserts.notNull((Object)bank, "bank can't be null");
        this.assertPaginationParameters(length, offset);
        this.bank = bank;
        this.length = length;
        this.offset = offset;
    }

    private void assertPaginationParameters(Long length, Long offset) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("length can't be less than or equal to zero");
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset can't be negative value");
        }
    }

    String paginationQueryParam() {
        return QueryParams.newQuery().with("length", this.length).with("offset", this.offset).toString();
    }
}

