/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.ach;

import ir.boommarket.Asserts;
import ir.boommarket.BoomApi;
import ir.boommarket.Json;
import ir.boommarket.Requests;
import ir.boommarket.ach.AchAutoTransfer;
import ir.boommarket.ach.AchAutoTransferRequest;
import ir.boommarket.ach.AchBatchTransfer;
import ir.boommarket.ach.AchBatchTransferRequest;
import ir.boommarket.ach.AchNormalTransfer;
import ir.boommarket.ach.AchNormalTransferRequest;
import ir.boommarket.ach.AchTransactionReportRequest;
import ir.boommarket.ach.AchTransactionsReport;
import ir.boommarket.ach.AchTransferReportRequest;
import ir.boommarket.ach.AchTransfersReport;
import okhttp3.Request;

public class Ach {
    public static AchNormalTransfer normalTransfer(AchNormalTransferRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be a null value");
        Asserts.notNull(boomApi, "boomApi can't be a null value");
        String url = boomApi.baseUrl() + "ach/transfer/normal";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, AchNormalTransfer.class);
    }

    public static AchBatchTransfer batchTransfer(AchBatchTransferRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be a null value");
        Asserts.notNull(boomApi, "boomApi can't be a null value");
        String url = boomApi.baseUrl() + "ach/transfer/batch";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, AchBatchTransfer.class);
    }

    public static AchAutoTransfer autoTransfer(AchAutoTransferRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be a null value");
        Asserts.notNull(boomApi, "boomApi can't be a null value");
        String url = boomApi.baseUrl() + "ach/transfer/auto";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, AchAutoTransfer.class);
    }

    public static AchTransfersReport transferReports(AchTransferReportRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be a null value");
        Asserts.notNull(boomApi, "boomApi can't be a null value");
        String url = boomApi.baseUrl() + "ach/reports/transfer";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, AchTransfersReport.class);
    }

    public static AchTransactionsReport transactionReports(AchTransactionReportRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be a null value");
        Asserts.notNull(boomApi, "boomApi can't be a null value");
        String url = boomApi.baseUrl() + "ach/reports/transaction";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, AchTransactionsReport.class);
    }
}

