/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.accounts;

import ir.boommarket.Asserts;
import ir.boommarket.BoomApi;
import ir.boommarket.Json;
import ir.boommarket.Requests;
import ir.boommarket.accounts.AccountInfo;
import ir.boommarket.accounts.AccountInfoRequest;
import ir.boommarket.accounts.BankLoginRequest;
import ir.boommarket.accounts.BankLoginResponse;
import okhttp3.Request;

public class Accounts {
    public static BankLoginResponse bankLogin(BankLoginRequest bankLoginRequest, BoomApi boomApi) {
        Asserts.notNull(bankLoginRequest, "bankLoginRequest can't be null");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "auth/login";
        Request request = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(bankLoginRequest)).build();
        return Requests.sendRequest(request, BankLoginResponse.class);
    }

    public static AccountInfo getInfo(AccountInfoRequest request, BoomApi boomApi) {
        Asserts.notNull(boomApi, "boomApi can't be null");
        if (request == null) {
            request = AccountInfoRequest.withoutAddress();
        }
        String url = boomApi.baseUrl() + "/accounts" + request.toQueryParam();
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).build();
        return Requests.sendRequest(httpRequest, AccountInfo.class);
    }
}

