package ir.afraapps.basic.view.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import ir.afraapps.basic.R;


/**
 * In the name of Allah
 * <p>
 * Created by ali on 11/3/17.
 */

public class UProgressDialog {

  private AlertDialog dialog;
  private Context     context;

  private String title;

  private int titleColor;

  private boolean darkTheme;
  private boolean cancelable;
  private boolean showButton;

  private Runnable actionDismiss;

  public UProgressDialog(Context context) {
    this.context = context;
  }

  public void show() {
    if (dialog != null && dialog.isShowing()) {
      dialog.dismiss();
    }

    if (darkTheme) {
      context = getDarkThemeContext();
    }

    AlertDialog.Builder builder = new AlertDialog.Builder(context);

    @SuppressLint("InflateParams")
    View content = LayoutInflater.from(context).inflate(R.layout.dialog_progress, null);
    TextView txtTitle = content.findViewById(R.id.title);

    if (titleColor != 0) {
      txtTitle.setTextColor(titleColor);
    }

    if (showButton) {
      TextView btn = content.findViewById(R.id.done);
      content.findViewById(R.id.progress).setVisibility(View.GONE);
      btn.setOnClickListener(v -> dialog.dismiss());
      btn.setVisibility(View.VISIBLE);

    } else {
      content.findViewById(R.id.progress).setVisibility(View.VISIBLE);
      content.findViewById(R.id.done).setVisibility(View.GONE);
    }

    txtTitle.setText(title);

    builder.setView(content);

    dialog = builder.create();
    dialog.setCancelable(cancelable);
    if (actionDismiss != null) {
      dialog.setOnDismissListener(dialog -> actionDismiss.run());
    }


    dialog.show();

  }

  @SuppressLint("RestrictedApi")
  private Context getDarkThemeContext() {
    return new ContextThemeWrapper(context, R.style.AlertDialogDarkTheme);
  }


  public UProgressDialog setTitle(String title) {
    this.title = title;
    return this;
  }

  public UProgressDialog setTitle(@StringRes int titleRes) {
    this.title = context.getString(titleRes);
    return this;
  }


  public UProgressDialog setTitleColor(@ColorInt int titleColor) {
    this.titleColor = titleColor;
    return this;
  }


  public UProgressDialog setCancelable(boolean cancelable) {
    this.cancelable = cancelable;
    return this;
  }

  public UProgressDialog showButton(boolean showButton) {
    this.showButton = showButton;
    return this;
  }

  public UProgressDialog setDismissAction(Runnable actionDismiss) {
    this.actionDismiss = actionDismiss;
    return this;
  }

  public UProgressDialog useDarkTheme() {
    this.darkTheme = true;
    return this;
  }


  public void dismiss() {
    if (dialog != null) {
      dialog.dismiss();
    }
  }


}
