package ir.afraapps.basic.core;

import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import java.lang.reflect.Field;

import ir.afraapps.basic.R;
import ir.afraapps.basic.view.USnackbar;
import ir.afraapps.basic.view.UToast;

/**
 * In the name of Allah
 * <p>
 * Created by ali on 11/6/17.
 */

public class BaseCompatActivity extends AppCompatActivity {

  private boolean showExitNotify;
  private boolean finishOnExit;
  private boolean finishActivity;

  @Override
  public void onBackPressed() {
    if (USnackbar.isShowing()) {
      USnackbar.dismiss();

    } else if (showExitNotify) {
      if (finishActivity) {
        ActivityCompat.finishAfterTransition(this);
        return;
      }

      finishActivity = true;
      UToast.show(R.string.exit_app);
      Base.postDelayed(() -> finishActivity = false, 2000);

    } else if (finishOnExit) {
      ActivityCompat.finishAfterTransition(this);

    } else {
      super.onBackPressed();
    }
  }

  public class Founder {

    private Object ui;

    private boolean noTitlebar;
    private boolean noActionbar;
    private boolean fullscreen;
    private boolean translucent;
    private boolean noStatusbar;
    private int[]   features;
    private int     layoutId;


    public Founder ViewModel(Object ui) {
      this.ui = ui;
      return this;
    }

    public Founder noTitlebar() {
      this.noTitlebar = true;
      return this;
    }

    public Founder noActionbar() {
      this.noActionbar = true;
      return this;
    }

    public Founder noStatusbar() {
      this.noStatusbar = true;
      return this;
    }


    public Founder translucent() {
      this.translucent = true;
      return this;
    }


    public Founder fullscreen() {
      this.fullscreen = true;
      return this;
    }

    public Founder requestFeature(int... features) {
      this.features = features;
      return this;
    }

    public Founder contentView(@LayoutRes int layoutId) {
      this.layoutId = layoutId;
      return this;
    }


    public Founder showExitNotify() {
      showExitNotify = true;
      return this;
    }


    public Founder finishOnExit() {
      finishOnExit = true;
      return this;
    }


    public void build() {
      if (features != null) {
        for (int feature : features) {
          getWindow().requestFeature(feature);
        }
      }

      if (noTitlebar) {
        getWindow().requestFeature(Window.FEATURE_NO_TITLE);
      }

      if (fullscreen) {
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
      }

      if (noActionbar) {
        getWindow().requestFeature(Window.FEATURE_ACTION_BAR);
        ActionBar actionBar = getSupportActionBar();
        if (actionBar != null) {
          actionBar.hide();
        }
      }

      if (translucent && Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS, WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
      }

      if (noStatusbar) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
          getWindow().getDecorView().setSystemUiVisibility(
            View.SYSTEM_UI_FLAG_LAYOUT_STABLE
              | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
          getWindow().setStatusBarColor(Color.TRANSPARENT);

        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
          getWindow().setFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS, WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
        }
      }


      setContentView(layoutId);

      extractViews();

    }


    private void extractViews() {
      if (ui == null) return;
      Class clazz = ui.getClass();

      Field[] fields = clazz.getDeclaredFields();

      String fieldName;

      for (Field field : fields) {
        fieldName = field.getName();

        if (fieldName.contains("$")) {
          continue;
        }

        int id = getResources().getIdentifier(fieldName, "id", getPackageName());

        if (id == 0) {
          continue;
        }

        try {
          field.setAccessible(true);
          field.set(ui, findViewById(id));
        } catch (IllegalAccessException e) {
          // e.printStackTrace();
        }
      }
    }

  }


  protected void setNavigationBarColor(@ColorInt int color) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
      getWindow().setNavigationBarColor(color);
    }
  }

  protected void setStatusBarColor(@ColorInt int color) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
      getWindow().setStatusBarColor(color);
    }
  }

  protected void transparentStatusBar() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
      getWindow().getDecorView().setSystemUiVisibility(
        View.SYSTEM_UI_FLAG_LAYOUT_STABLE
          | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN);
      getWindow().setStatusBarColor(Color.TRANSPARENT);

    } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
      getWindow().setFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS, WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
    }
  }


}
