package ir.afraapps.basic.core;

import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.lang.reflect.Field;

/**
 * In the name of Allah
 * <p>
 * Created by ali on 11/6/17.
 */

public class BaseCompatFragment extends Fragment {


  public class Founder {

    private Object ui;
    private View   root;


    public Founder ViewModel(Object ui) {
      this.ui = ui;
      return this;
    }


    public Founder inflate(LayoutInflater inflater, @Nullable ViewGroup container, @LayoutRes int layoutId) {
      root = inflater.inflate(layoutId, container, false);
      return this;
    }


    public View build() {
      extractViews();
      return root;
    }


    private void extractViews() {
      if (root == null || ui == null) return;
      Class clazz = ui.getClass();

      Field[] fields = clazz.getDeclaredFields();

      String fieldName;

      for (Field field : fields) {
        fieldName = field.getName();

        if (fieldName.contains("$")) {
          continue;
        }

        int id = getResources().getIdentifier(fieldName, "id", getContext().getPackageName());

        if (id == 0) {
          continue;
        }

        try {
          field.setAccessible(true);
          field.set(ui, root.findViewById(id));
        } catch (IllegalAccessException e) {
          // e.printStackTrace();
        }
      }
    }

  }


}
