package ir.afraapps.basic.helper;

import android.content.Context;
import android.os.Build;
import android.support.annotation.StyleRes;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

/**
 * In the name of Allah
 * <p>
 * Created by ali on 11/7/17.
 */

public class UView {

  public static void setTextAppearance(Context context, TextView textView, @StyleRes int style) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
      textView.setTextAppearance(style);
    } else {
      textView.setTextAppearance(context, style);
    }
  }


  public static void selectViewChildes(ViewGroup viewGroup, boolean select) {
    if (viewGroup == null) return;
    int childCount = viewGroup.getChildCount();
    for (int i = 0; i < childCount; i++) {
      View child = viewGroup.getChildAt(i);
      child.setSelected(select);
      if (child instanceof ViewGroup) {
        selectViewChildes((ViewGroup) child, select);
      }
    }
  }


  public static void enableViewChildes(ViewGroup viewGroup, boolean enabled) {
    if (viewGroup == null) return;

    viewGroup.setEnabled(enabled);
    int childCount = viewGroup.getChildCount();
    for (int i = 0; i < childCount; i++) {
      View child = viewGroup.getChildAt(i);
      child.setEnabled(enabled);
      if (child instanceof ViewGroup) {
        enableViewChildes((ViewGroup) child, enabled);
      }
    }
  }


  public static void activateViewChildes(ViewGroup viewGroup, boolean activated) {
    if (viewGroup == null) return;

    viewGroup.setActivated(activated);
    int childCount = viewGroup.getChildCount();
    for (int i = 0; i < childCount; i++) {
      View child = viewGroup.getChildAt(i);
      child.setActivated(activated);
      if (child instanceof ViewGroup) {
        activateViewChildes((ViewGroup) child, activated);
      }
    }
  }


}
