package ir.afraapps.basic.helper;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

import ir.afraapps.basic.core.Base;

/**
 * In the name of Allah
 * <p>
 * Created by ali on 11/10/17.
 */

public class USoftKeyboard {

  public static void close(Activity context) {
    View view = context.getCurrentFocus();
    if (view != null) {
      get().hideSoftInputFromWindow(view.getWindowToken(), InputMethodManager.RESULT_UNCHANGED_SHOWN);
    }
  }


  public static void show(EditText editText) {
    editText.requestFocus();
    get().showSoftInput(editText, InputMethodManager.SHOW_FORCED);
  }


  private static InputMethodManager get() {
    return (InputMethodManager) Base.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
  }


}
