package ir.afraapps.basic.helper;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;

import ir.afraapps.basic.R;
import ir.afraapps.basic.core.Base;

/**
 * In the name of Allah
 * <p>
 * Created by ali on 11/9/17.
 */

public class UColor {


  public static int getAttrColor(int attr) {
    TypedValue typedValue = new TypedValue();

    TypedArray a     = Base.getContext().obtainStyledAttributes(typedValue.data, new int[]{attr});
    int        color = a.getColor(0, 0);

    a.recycle();

    return color;
  }


  public static int getAttrColor(Context context, int attr) {
    TypedValue typedValue = new TypedValue();

    TypedArray a     = context.obtainStyledAttributes(typedValue.data, new int[]{attr});
    int        color = a.getColor(0, 0);

    a.recycle();

    return color;
  }


  public static int getPrimaryColor() {
    return getAttrColor(R.attr.colorPrimary);
  }


  public static int getPrimaryColor(Context context) {
    return getAttrColor(context, R.attr.colorPrimary);
  }


  public static int getPrimaryDarkColor() {
    return getAttrColor(R.attr.colorPrimaryDark);
  }


  public static int getPrimaryDarkColor(Context context) {
    return getAttrColor(context, R.attr.colorPrimaryDark);
  }


  public static int getAccentColor() {
    return getAttrColor(R.attr.colorAccent);
  }


  public static int getAccentColor(Context context) {
    return getAttrColor(context, R.attr.colorAccent);
  }


  public static int get(@ColorRes int res) {
    return ContextCompat.getColor(Base.getContext(), res);
  }


}
