---
title: Contributing 
---

# Contributing

For the long-term success of DSBench, we need as many hands on deck as possible.
We want to make it easy for anyone at DataStax to improve DSBench.

If you are looking to take on some development, reach out at dsbench@datastax.com
or in the #ebdse-devs slack channel to collaborate. For non-trivial items in particular,
we want to be involved early on to ensure that the proposed feature and design fits into the tool's
direction as a product.

See the sections below for details on contributing to DSBench.


## Collab
We tag all Github Issues that we feel would be a good fit for casual contributors
with a `collab` tag. These issues are a good place to start if you want to do some
development on DSBench.

If you choose to pick up one of these items, please make yourself the Assignee
in Github and shoot us an email at dsbench@datastax.com or post in the #ebdse-devs slack channel to
let us know that you are starting work on a task.

link


## Roadmap
We have a prioritized roadmap that holds the larger items that we want to tackle.
Some of these are net few features and others are bringing existing
functionality that is in the private EBDSE into the public DSBench.

In general, these features are complex and the work required is likely not
suited for the casual contributor, but if you feel like you have the familiarity
with the code base to grab one of these items, we will be more than happy to have
a conversation. To start that process, send an email to dsbench@datastax.com with
the Github Issue that you intend to work on.

The roadmap can be found in the link below.

link


## Free Climb
We by no means want to limit the creativity of contributors and in many cases
there may be features that you want to work on that are not called out in the
collaboration bucket or in the roadmap. This is fine! Send us an email at
dsbench@datastax.com and let us know what you want to implement. We will chat
about the feature and make sure that it's use aligns with the DSBench objectives.


## Code Layout
Show the high level project structure and where things live


## Code Guidelines

Need input from Shooky & Seb
- What code styles are required?
- What are our unit / integration testing requirements?
- What general rules do people need to follow?
