/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavIconHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(FavIconHandler.class);
    private final Path faviconPath;
    byte[] iconData;
    private long lastModified = 0L;

    public FavIconHandler(String string, boolean bl) {
        this.faviconPath = Path.of(string, new String[0]);
        if (!this.faviconPath.toFile().exists() && bl) {
            throw new InvalidParameterException("favicon faviconPath " + this.faviconPath.toString() + " does not exist.");
        }
    }

    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (request.isHandled() || httpServletResponse.isCommitted()) {
            return;
        }
        if (!HttpMethod.GET.is(httpServletRequest.getMethod()) || !string.equals("/favicon.ico")) {
            return;
        }
        if (!this.faviconPath.toFile().exists()) {
            return;
        }
        this.lastModified = this.faviconPath.toFile().lastModified();
        if (httpServletRequest.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString()) == this.lastModified) {
            httpServletResponse.setStatus(304);
            return;
        }
        request.setHandled(true);
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/eclipse/jetty/favicon.ico");
        if (uRL != null) {
            Resource resource = Resource.newResource((URL)uRL);
            this.iconData = IO.readBytes((InputStream)resource.getInputStream());
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("image/x-icon");
        httpServletResponse.setContentLength(this.iconData.length);
        httpServletResponse.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), this.lastModified);
        httpServletResponse.setHeader(HttpHeader.CACHE_CONTROL.toString(), "max-age=360000,public");
        httpServletResponse.getOutputStream().write(this.iconData);
    }
}

