/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.core;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathWalker {
    private static final Logger logger = LoggerFactory.getLogger(PathWalker.class);
    public static DirectoryStream.Filter<Path> WALK_ALL = path -> true;

    public static void walk(Path path, PathVisitor pathVisitor) {
        PathWalker.walk(path, pathVisitor, WALK_ALL);
    }

    public static List<Path> findAll(Path path) {
        Collect collect = new Collect(true, false);
        PathWalker.walk(path, collect);
        return collect.get();
    }

    public static void walk(Path path2, PathVisitor pathVisitor, DirectoryStream.Filter<Path> filter) {
        try {
            FileSystemProvider fileSystemProvider = path2.getFileSystem().provider();
            DirectoryStream<Path> directoryStream = fileSystemProvider.newDirectoryStream(path2, path -> true);
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path3 : directoryStream) {
                arrayList.add(path3);
            }
            for (Path path3 : arrayList) {
                if (path3.getFileSystem().provider().readAttributes(path3, BasicFileAttributes.class, new LinkOption[0]).isDirectory()) {
                    pathVisitor.preVisitDir(path3);
                    PathWalker.walk(path3, pathVisitor, filter);
                    pathVisitor.postVisitDir(path3);
                    continue;
                }
                if (filter.accept(path3)) {
                    pathVisitor.preVisitFile(path3);
                    pathVisitor.visit(path3);
                    pathVisitor.postVisitFile(path3);
                    continue;
                }
                logger.error("error");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static class Collect
    implements PathVisitor {
        private final List<Path> listing = new ArrayList<Path>();
        private final boolean collectFiles;
        private final boolean collectDirectories;

        public Collect(boolean bl, boolean bl2) {
            this.collectFiles = bl;
            this.collectDirectories = bl2;
        }

        public List<Path> get() {
            return this.listing;
        }

        @Override
        public void visit(Path path) {
        }

        @Override
        public void preVisitFile(Path path) {
            if (this.collectFiles) {
                this.listing.add(path);
            }
        }

        @Override
        public void preVisitDir(Path path) {
            if (this.collectDirectories) {
                this.listing.add(path);
            }
        }
    }

    public static interface PathVisitor {
        public void visit(Path var1);

        default public void preVisitFile(Path path) {
        }

        default public void postVisitFile(Path path) {
        }

        default public void preVisitDir(Path path) {
        }

        default public void postVisitDir(Path path) {
        }
    }
}

