/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.core;

import io.virtdata.annotations.Service;
import io.virtdata.docsys.api.Docs;
import io.virtdata.docsys.api.DocsBinder;
import io.virtdata.docsys.api.DocsNameSpace;
import io.virtdata.docsys.api.WebServiceObject;
import io.virtdata.docsys.core.DocsysPathLoader;
import io.virtdata.docsys.core.PathWalker;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value=WebServiceObject.class)
@Singleton
@Path(value="/services/docs/")
public class DocsysDynamicService
implements WebServiceObject {
    private static final Logger logger = LoggerFactory.getLogger(DocsysDynamicService.class);
    private DocsBinder docsinfo;
    private DocsBinder enabled;
    private DocsBinder disabled;
    private AtomicLong version = new AtomicLong(System.nanoTime());
    private final Set<String> enables = new HashSet<String>();

    @GET
    @Produces(value={"application/json"})
    @Path(value="version")
    public long getVersion() {
        return this.version.get();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="namespaces")
    public Map<String, Map<String, Set<java.nio.file.Path>>> getNamespaces(@QueryParam(value="enable") String string, @QueryParam(value="reload") boolean bl) {
        if (string != null && !string.isEmpty()) {
            this.enables.clear();
            this.enables.addAll(List.of(string.split("[, ;]")));
        }
        this.init(bl);
        this.enable(this.enables);
        return Map.of("enabled", this.enabled.getPathMap(), "disabled", this.disabled.getPathMap());
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="allfiles.csv")
    public String getAllfilesList(@QueryParam(value="reload") boolean bl) {
        this.init(bl);
        StringBuilder stringBuilder = new StringBuilder();
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            PathWalker.findAll(path).forEach(path2 -> stringBuilder.append(path.relativize((java.nio.file.Path)path2).toString()).append("\n"));
        }
        return stringBuilder.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="markdown.csv")
    public String getMarkdownList(@QueryParam(value="reload") boolean bl) {
        this.init(bl);
        StringBuilder stringBuilder = new StringBuilder();
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            PathWalker.findAll(path).forEach(path2 -> {
                if (path2.toString().endsWith(".md")) {
                    stringBuilder.append(path.relativize((java.nio.file.Path)path2).toString()).append("\n");
                }
            });
        }
        return stringBuilder.toString();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    public List<String> listFiles(@QueryParam(value="reload") boolean bl) {
        this.init(bl);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            PathWalker.findAll(path).forEach(path2 -> {
                java.nio.file.Path path3 = path.relativize((java.nio.file.Path)path2);
                arrayList.add(path3.toString());
            });
        }
        return arrayList;
    }

    @GET
    @Path(value="file")
    @Produces(value={"text/plain"})
    public String getFileByPath(@QueryParam(value="path") String string) {
        return this.getFile(string);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="markdown/{pathspec:.*}")
    public String getFileInPath(@PathParam(value="pathspec") String string) {
        return this.getFile(string);
    }

    private String getFile(String string) {
        string = URLDecoder.decode(string, StandardCharsets.UTF_8);
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            java.nio.file.Path path2 = path.resolve(string);
            if (Files.isDirectory(path2, new LinkOption[0])) {
                throw new RuntimeException("Path is a directory: '" + string + "'");
            }
            if (!Files.exists(path2, new LinkOption[0])) continue;
            try {
                String string2 = Files.readString(path2, StandardCharsets.UTF_8);
                return string2;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        throw new RuntimeException("Unable to find any valid file at '" + string + "'");
    }

    private void init(boolean bl) {
        if (bl) {
            this.enabled = null;
            this.disabled = null;
            this.docsinfo = null;
        }
        if (this.docsinfo == null) {
            this.docsinfo = DocsysPathLoader.loadDynamicPaths();
            this.version.set(System.nanoTime());
        }
        if (this.enabled == null || this.disabled == null) {
            this.enable(this.enables);
        }
    }

    private void enable(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.enables != null) {
            hashSet.addAll(this.enables);
        }
        for (DocsNameSpace docsNameSpace : this.docsinfo) {
            if (!docsNameSpace.isEnabledByDefault() || this.disabled != null && this.disabled.getPathMap().containsKey(docsNameSpace.getName())) continue;
            this.enables.add(docsNameSpace.getName());
        }
        if (set.isEmpty()) {
            this.enabled = new Docs().merge(this.docsinfo);
            this.disabled = new Docs().asDocsBinder();
        } else {
            this.disabled = new Docs().merge(this.docsinfo);
            this.enabled = this.disabled.remove(set);
        }
    }
}

