/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.core;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import io.virtdata.docsys.core.DocServer;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocServerApp {
    public static final String APPNAME_DOCSERVER = "docserver";
    private static final Logger logger;

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].contains("help")) {
            DocServerApp.showHelp(new String[0]);
        } else {
            DocServerApp.runServer(stringArray);
        }
    }

    private static void configureDocServerLogging(LoggerContext loggerContext) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext((Context)loggerContext);
        loggerContext.reset();
        loggerContext.putProperty("application-name", APPNAME_DOCSERVER);
        InputStream inputStream = DocServerApp.class.getClassLoader().getResourceAsStream("logback-docsys.xml");
        if (inputStream != null) {
            try {
                joranConfigurator.doConfigure(inputStream);
            }
            catch (JoranException joranException) {
                System.err.println("error initializing logging system: " + joranException.getMessage());
                throw new RuntimeException(joranException);
            }
        } else {
            throw new RuntimeException("No logging context was provided, and logback-docsys.xml could not be loaded from the classpath.");
        }
    }

    private static void runServer(String[] stringArray) {
        DocServer docServer = new DocServer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.matches(".*://.*")) {
                if (!string.toLowerCase().contains("http://")) {
                    String string2 = string.toLowerCase().replaceAll("https", "http");
                    throw new RuntimeException("ERROR:\nIn this release, only 'http://' URLs are supported.\nTLS will be added in a future release.\nSee https://github.com/datastax/dsbench-labs/issues/29\nConsider using " + string2);
                }
                docServer.withURL(string);
                continue;
            }
            if (Files.exists(Path.of(string, new String[0]), new LinkOption[0])) {
                docServer.addPaths(Path.of(string, new String[0]));
                continue;
            }
            if (string.matches("\\d+")) {
                docServer.withPort(Integer.parseInt(string));
                continue;
            }
            if (!string.matches("--public")) continue;
            docServer.withHost("0.0.0.0");
        }
        docServer.run();
    }

    private static void showHelp(String ... stringArray) {
        System.out.println("Usage: docserver  [url]  [path]... \n\nIf [url] is provided, then the scheme, address and port are all taken from it.\nAny additional paths are served from the filesystem, in addition to the internal ones.\n\nFor now, only http:// is supported.");
    }

    private static void search(String[] stringArray) {
    }

    private static void listTopics() {
    }

    static {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        if (loggerContext.getLoggerList().size() == 1 && ((ch.qos.logback.classic.Logger)loggerContext.getLoggerList().get(0)).getName().equals("ROOT")) {
            DocServerApp.configureDocServerLogging(loggerContext);
            logger = LoggerFactory.getLogger(DocServerApp.class);
            logger.info("Configured logging system from logback-docsys.xml");
        } else {
            logger = LoggerFactory.getLogger(DocServerApp.class);
            logger.info("Configured logging within existing logging context.");
        }
    }
}

