/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.core;

import io.virtdata.docsys.DocsysDefaultAppPath;
import io.virtdata.docsys.api.Docs;
import io.virtdata.docsys.api.WebServiceObject;
import io.virtdata.docsys.core.DocsysPathLoader;
import io.virtdata.docsys.core.WebObjectLoader;
import io.virtdata.docsys.handlers.FavIconHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DocServer.class);
    private final List<Path> basePaths = new ArrayList<Path>();
    private final List<Class> servletClasses = new ArrayList<Class>();
    private ServletContextHandler contextHandler;
    private ServletHolder servletHolder;
    private HandlerList handlers;
    private String bindScheme = "http";
    private String bindHost = "localhost";
    private int bindPort = 12345;

    public DocServer withHost(String string) {
        this.bindHost = string;
        return this;
    }

    public DocServer withPort(int n) {
        this.bindPort = n;
        return this;
    }

    public DocServer withURL(String string) {
        try {
            URL uRL = new URL(string);
            this.bindPort = uRL.getPort();
            this.bindHost = uRL.getHost();
            this.bindScheme = uRL.getProtocol();
            if (uRL.getPath() != null && !uRL.getPath().equals("/") && !uRL.getPath().equals("")) {
                throw new UnsupportedOperationException("You may not specify a path for the hosting URL. (specified '" + uRL.getPath() + "')");
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this;
    }

    public DocServer withScheme(String string) {
        this.bindScheme = string;
        return this;
    }

    private void addWebObject(Class ... classArray) {
        this.servletClasses.addAll(Arrays.asList(classArray));
    }

    private void loadDynamicEndpoints() {
        List<WebServiceObject> list = WebObjectLoader.loadWebServiceObjects();
        for (WebServiceObject webServiceObject : list) {
            logger.info("Adding web service object: " + webServiceObject.toString());
            this.addWebObject(webServiceObject.getClass());
        }
        logger.debug("Loaded " + this.servletClasses.size() + " root resources.");
    }

    private ServletContextHandler getContextHandler() {
        if (this.contextHandler == null) {
            this.contextHandler = new ServletContextHandler();
            this.contextHandler.setContextPath("/*");
        }
        return this.contextHandler;
    }

    private ServletHolder getServletHolder() {
        if (this.servletHolder == null) {
            this.servletHolder = this.getContextHandler().addServlet(ServletContainer.class, "/apps");
            this.servletHolder.setInitOrder(0);
        }
        return this.servletHolder;
    }

    public DocServer addPaths(Path ... pathArray) {
        for (Path path : pathArray) {
            try {
                path.getFileSystem().provider().checkAccess(path, AccessMode.READ);
                this.basePaths.add(path);
            }
            catch (Exception exception) {
                logger.error("Unable to access path " + path.toString());
                throw new RuntimeException(exception);
            }
        }
        return this;
    }

    @Override
    public void run() {
        ResourceConfig resourceConfig;
        Object object;
        Path path;
        Path path22;
        Server server = new Server(this.bindPort);
        this.handlers = new HandlerList();
        if (this.basePaths.size() == 0 && this.servletClasses.size() == 0) {
            logger.warn("No service endpoints or doc paths have been added. Loading dynamically.");
        }
        RewriteHandler rewriteHandler = new RewriteHandler();
        this.handlers.addHandler((Handler)rewriteHandler);
        for (Path path22 : this.basePaths) {
            path = path22.resolve("/favicon.ico");
            if (!Files.exists(path, new LinkOption[0])) continue;
            object = new FavIconHandler(this.basePaths.get(0) + "/favicon.ico", false);
            this.handlers.addHandler((Handler)object);
            break;
        }
        if (this.basePaths.size() == 0) {
            resourceConfig = new Docs();
            resourceConfig.merge(DocsysPathLoader.loadStaticPaths());
            if (!resourceConfig.getPathMap().containsKey("docsys-app")) {
                resourceConfig.merge(new DocsysDefaultAppPath().getDocs());
            }
            this.basePaths.addAll(resourceConfig.getPaths());
        }
        for (Path path22 : this.basePaths) {
            logger.info("Adding path to server: " + path22.toString());
            path = new ResourceHandler();
            path.setDirAllowed(true);
            path.setAcceptRanges(true);
            path.setWelcomeFiles(new String[]{"index.html"});
            path.setRedirectWelcome(false);
            object = new PathResource(path22);
            if (path22.toUri().toString().startsWith("jar:")) {
                try {
                    object = JarResource.newResource((URI)path22.toUri());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
            }
            path.setBaseResource((org.eclipse.jetty.util.resource.Resource)object);
            path.setCacheControl("no-cache");
            this.handlers.addHandler((Handler)path);
        }
        logger.info("adding " + this.servletClasses.size() + " context handlers...");
        this.loadDynamicEndpoints();
        resourceConfig = new ResourceConfig();
        resourceConfig.property("server", (Object)this);
        path22 = new ServletContainer(resourceConfig);
        path = new ServletHolder((Servlet)path22);
        object = this.servletClasses.stream().map(Class::getCanonicalName).collect(Collectors.joining(","));
        resourceConfig.property("jersey.config.server.provider.classnames", object);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/*");
        servletContextHandler.addServlet((ServletHolder)path, "/*");
        FilterHolder filterHolder = new FilterHolder();
        filterHolder.setInitParameter("allowedOrigins", "*");
        filterHolder.setInitParameter("allowedMethods", "POST,GET,OPTIONS,PUT,DELETE,HEAD");
        filterHolder.setInitParameter("allowedHeaders", "X-PINGOTHER, Origin, X-Requested-With, Content-Type, Accept");
        filterHolder.setInitParameter("preflightMaxAge", "1800");
        filterHolder.setInitParameter("allowCredentials", "true");
        CrossOriginFilter crossOriginFilter = new CrossOriginFilter();
        filterHolder.setFilter((Filter)crossOriginFilter);
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
        filterMapping.setPathSpec("/*");
        filterMapping.setServletName("cross-origin");
        servletContextHandler.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        this.handlers.addHandler((Handler)servletContextHandler);
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setShowContexts(true);
        defaultHandler.setServeIcon(false);
        this.handlers.addHandler((Handler)defaultHandler);
        server.setHandler((Handler)this.handlers);
        for (Connector connector : server.getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            logger.debug("Setting idle timeout for " + connector.toString() + " to 300,000ms");
            ((AbstractConnector)connector).setIdleTimeout(300000L);
        }
        try {
            ArrayList arrayList = new ArrayList();
            if (this.bindScheme.equals("http")) {
                ServerConnector serverConnector = new ServerConnector(server);
                serverConnector.setPort(this.bindPort);
                serverConnector.setHost(this.bindHost);
                arrayList.add(serverConnector);
            } else if (this.bindScheme.equals("https")) {
                SslContextFactory.Server server2 = new SslContextFactory.Server();
                ServerConnector serverConnector = new ServerConnector(server, (SslContextFactory)server2);
                serverConnector.setPort(this.bindPort);
                serverConnector.setHost(this.bindHost);
                arrayList.add(serverConnector);
            }
            server.setConnectors(arrayList.toArray(new Connector[0]));
            server.start();
            logger.info("Started documentation server at " + this.bindScheme + "://" + this.bindHost + ":" + this.bindPort + "/");
            System.out.println("Started documentation server at " + this.bindScheme + "://" + this.bindHost + ":" + this.bindPort + "/");
            server.join();
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            exception.printStackTrace(System.out);
            System.exit(2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class clazz : this.servletClasses) {
            stringBuilder.append("- ").append(clazz.getCanonicalName()).append("\n");
            ResourceConfig resourceConfig = new ResourceConfig(new Class[]{clazz});
            Set object2 = resourceConfig.getResources();
            for (Resource resource : object2) {
                stringBuilder.append("resource name:").append(resource.getName()).append("\n");
                List list = resource.getResourceMethods();
                for (ResourceMethod resourceMethod : list) {
                    String string = resourceMethod.toString();
                    stringBuilder.append("rm:").append(string);
                }
            }
        }
        stringBuilder.append("- - - -\n");
        for (Handler handler : this.handlers.getHandlers()) {
            String string = this.handlerSummary(handler);
            stringBuilder.append((String)(string == null ? "NULL SUMMARY" : string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private String handlerSummary(Handler handler) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("----> handler type ").append(handler.getClass().getSimpleName()).append("\n");
        if (handler instanceof ResourceHandler) {
            ResourceHandler resourceHandler = (ResourceHandler)handler;
            stringBuilder.append(" base resource: ").append(resourceHandler.getBaseResource().toString()).append("\n");
            stringBuilder.append(resourceHandler.dump());
        } else if (handler instanceof ServletContextHandler) {
            ServletContextHandler servletContextHandler = (ServletContextHandler)handler;
            stringBuilder.append(servletContextHandler.dump()).append("\n");
            servletContextHandler.getServletContext().getServletRegistrations().forEach((string, servletRegistration) -> {
                stringBuilder.append("==> servlet type ").append((String)string).append("\n");
                stringBuilder.append(this.getServletSummary((ServletRegistration)servletRegistration)).append("\n");
            });
            stringBuilder.append("context path:").append(servletContextHandler.getContextPath());
        } else if (handler instanceof DefaultHandler) {
            DefaultHandler defaultHandler = (DefaultHandler)handler;
            stringBuilder.append(defaultHandler.dump());
        }
        return stringBuilder.toString();
    }

    private String getServletSummary(ServletRegistration servletRegistration) {
        return servletRegistration.getClassName() + "('" + servletRegistration.getName() + "')" + servletRegistration.getInitParameters().keySet().stream().map(string -> string + "=" + (String)servletRegistration.getInitParameters().get(string)).collect(Collectors.joining(","));
    }
}

