/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.api;

import io.virtdata.docsys.api.DocsNameSpace;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DocsNameSpaceImpl
implements DocsNameSpace {
    private final Set<Path> paths = new HashSet<Path>();
    private String namespace;
    private boolean enabledByDefault = false;

    public DocsNameSpaceImpl() {
    }

    public static DocsNameSpaceImpl of(String string, Path path) {
        return new DocsNameSpaceImpl().setNameSpace(string).addPath(path);
    }

    private DocsNameSpaceImpl setNameSpace(String string) {
        this.namespace = string;
        return this;
    }

    public DocsNameSpaceImpl(String string) {
        this.namespace = string;
    }

    @Override
    public String getName() {
        return this.namespace;
    }

    @Override
    public List<Path> getPaths() {
        return new ArrayList<Path>(this.paths);
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public String toString() {
        return "DocPath{namespace='" + this.namespace + "',paths=" + this.paths.toString() + "}";
    }

    public DocsNameSpaceImpl addPath(Path path) {
        this.paths.add(path);
        return this;
    }

    public DocsNameSpaceImpl enabledByDefault() {
        this.enabledByDefault = true;
        return this;
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }

    public DocsNameSpaceImpl setEnabledByDefault(boolean bl) {
        this.enabledByDefault = bl;
        return this;
    }
}

