/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.docsys.api;

import io.virtdata.docsys.api.DocsBinder;
import io.virtdata.docsys.api.DocsNameSpace;
import io.virtdata.docsys.api.DocsNameSpaceImpl;
import io.virtdata.util.VirtDataResources;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Docs
implements DocsBinder {
    private LinkedList<DocsNameSpaceImpl> namespaces = new LinkedList();

    public Docs namespace(String string) {
        return this.addNamespace(string);
    }

    public Docs addFirstFoundPath(String ... stringArray) {
        Path path = VirtDataResources.findPathIn((String[])stringArray);
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("Unable to find a path in one of " + Arrays.stream(stringArray).collect(Collectors.joining(",")));
        }
        return this.addPath(path);
    }

    public Docs addPath(Path path) {
        if (this.namespaces.peekLast() == null) {
            throw new RuntimeException("You must add a namespace first.");
        }
        this.namespaces.peekLast().addPath(path);
        return this;
    }

    public Docs setEnabledByDefault(boolean bl) {
        if (this.namespaces.peekLast() == null) {
            throw new RuntimeException("You must add a namespace first.");
        }
        this.namespaces.peekLast().setEnabledByDefault(bl);
        return this;
    }

    private Docs addNamespace(String string) {
        this.namespaces.add(new DocsNameSpaceImpl(string));
        return this;
    }

    @Override
    public DocsBinder merge(DocsBinder docsBinder) {
        for (DocsNameSpace docsNameSpace : docsBinder.getNamespaces()) {
            this.namespace(docsNameSpace.getName());
            this.setEnabledByDefault(docsNameSpace.isEnabledByDefault());
            for (Path path : docsNameSpace.getPaths()) {
                this.addPath(path);
            }
        }
        return this.asDocsBinder();
    }

    @Override
    public DocsBinder merge(DocsNameSpace docsNameSpace) {
        this.namespace(docsNameSpace.getName());
        this.setEnabledByDefault(docsNameSpace.isEnabledByDefault());
        for (Path path : docsNameSpace) {
            this.addPath(path);
        }
        return this.asDocsBinder();
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (DocsNameSpaceImpl docsNameSpaceImpl : this.namespaces) {
            arrayList.addAll(docsNameSpaceImpl.getPaths());
        }
        return arrayList;
    }

    @Override
    public Map<String, Set<Path>> getPathMap() {
        HashMap<String, Set<Path>> hashMap = new HashMap<String, Set<Path>>();
        for (DocsNameSpaceImpl docsNameSpaceImpl : this.namespaces) {
            hashMap.put(docsNameSpaceImpl.getName(), new HashSet<Path>(docsNameSpaceImpl.getPaths()));
        }
        return hashMap;
    }

    @Override
    public List<DocsNameSpace> getNamespaces() {
        return new LinkedList<DocsNameSpace>(this.namespaces);
    }

    @Override
    public Iterator<DocsNameSpace> iterator() {
        ArrayList<DocsNameSpaceImpl> arrayList = new ArrayList<DocsNameSpaceImpl>(this.namespaces);
        return arrayList.iterator();
    }

    public Map<String, Set<Path>> getPathMaps() {
        HashMap<String, Set<Path>> hashMap = new HashMap<String, Set<Path>>();
        for (DocsNameSpaceImpl docsNameSpaceImpl : this.namespaces) {
            HashSet hashSet = new HashSet();
            docsNameSpaceImpl.forEach(hashSet::add);
            hashMap.put(docsNameSpaceImpl.getName(), hashSet);
        }
        return hashMap;
    }

    public DocsBinder asDocsBinder() {
        return this;
    }

    @Override
    public DocsBinder remove(Set<String> set) {
        Docs docs = new Docs();
        ListIterator listIterator = this.namespaces.listIterator();
        while (listIterator.hasNext()) {
            DocsNameSpaceImpl docsNameSpaceImpl = (DocsNameSpaceImpl)listIterator.next();
            if (!set.contains(docsNameSpaceImpl.getName())) continue;
            listIterator.previous();
            listIterator.remove();
            docs.merge(docsNameSpaceImpl);
        }
        return docs;
    }
}

