/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.annotations;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExampleData {
    public static Pattern CTOR_PATTERN = Pattern.compile("(?<funcname>[^)]+)\\((?<args>.+)\\)");
    public static Pattern VALS_PATTERN = Pattern.compile("\\[(?<values>-?\\d+([,-. ]+-?\\d+)*)]");
    private Pattern COMMA_VALS = Pattern.compile("\\[(?<vals>-?\\d+(,-?\\d+)*)]");
    private Pattern RANGE_VALS = Pattern.compile("\\[(?<from>-?\\d+)\\.\\.(?<to>-?\\d+)( +(?<step>-?\\d+))?]");
    public String[] parts;

    public ExampleData(String[] parts) {
        this.parts = parts;
    }

    public static void validateExamples(List<List<String>> examples) {
        for (List<String> example : examples) {
            for (String examplePart : example) {
                if (CTOR_PATTERN.matcher(examplePart).matches() || VALS_PATTERN.matcher(examplePart).matches()) continue;
                if (!examplePart.startsWith("[")) {
                    return;
                }
                throw new RuntimeException("Unable to match a valid pattern for example fragment '" + examplePart + "'). See javadoc for the Example annotation for details.");
            }
        }
    }

    public long[] getLongInputs() {
        long[] vals = new long[]{};
        for (String part : this.parts) {
            if (!VALS_PATTERN.matcher(part).matches()) continue;
            String[] specs = part.split(";");
            long[][] genvals = new long[specs.length][];
            int len = 0;
            for (int i = 0; i < genvals.length; ++i) {
                String spec = specs[i];
                genvals[i] = this.parseRange(spec);
                len += genvals[i].length;
            }
            vals = new long[len];
            int atlen = 0;
            for (int i = 0; i < genvals.length; ++i) {
                System.arraycopy(genvals[i], 0, vals, atlen, genvals[i].length);
                atlen += genvals[i].length;
            }
        }
        return vals;
    }

    private long[] parseRange(String spec) {
        Matcher comma_matcher = this.COMMA_VALS.matcher(spec);
        if (comma_matcher.matches()) {
            String vals = comma_matcher.group("vals");
            long[] longvals = Arrays.stream(vals.split(",")).mapToLong(Long::valueOf).toArray();
            return longvals;
        }
        Matcher range_matcher = this.RANGE_VALS.matcher(spec);
        if (range_matcher.matches()) {
            long from = Long.parseLong(range_matcher.group("from"));
            long to = Long.parseLong(range_matcher.group("to"));
            String step_size = range_matcher.group("step");
            long step = 1L;
            if (step_size != null) {
                step = Long.parseLong(step_size);
            }
            if (from < to && step <= 0L) {
                throw new RuntimeException("for increasing from-to of (" + from + "-" + to + ":, stepsize must be positive.");
            }
            if (from > to && step >= 0L) {
                throw new RuntimeException("for decreasing from-to of (" + from + "-" + to + ":, stepsize must be negative.");
            }
            long sizeL = Math.abs(from - to) / Math.abs(step) + 1L;
            if (sizeL > Integer.MAX_VALUE) {
                throw new RuntimeException("example size " + sizeL + " is too big.");
            }
            long[] vals = new long[(int)sizeL];
            long sign = step > 0L ? 1L : -1L;
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = from + step * (long)i;
            }
            return vals;
        }
        throw new RuntimeException("Unable to parse spec pattern: '" + spec + "'");
    }
}

