/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec;

import com.hazelcast.sql.impl.exec.AbstractUpstreamAwareExec;
import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.row.EmptyRowBatch;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.ListRowBatch;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import java.util.ArrayList;
import java.util.List;

public class ProjectExec
extends AbstractUpstreamAwareExec {
    private final List<Expression> projects;
    private RowBatch currentBatch;

    public ProjectExec(int id, Exec upstream, List<Expression> projects) {
        super(id, upstream);
        this.projects = projects;
    }

    @Override
    public IterationResult advance0() {
        RowBatch upstreamBatch;
        block2: {
            do {
                if (!this.state.advance()) {
                    return IterationResult.WAIT;
                }
                upstreamBatch = this.state.consumeBatch();
                if (upstreamBatch.getRowCount() != 0) break block2;
            } while (!this.state.isDone());
            this.currentBatch = EmptyRowBatch.INSTANCE;
            return IterationResult.FETCHED_DONE;
        }
        this.currentBatch = this.projectBatch(upstreamBatch);
        return this.state.isDone() ? IterationResult.FETCHED_DONE : IterationResult.FETCHED;
    }

    @Override
    public RowBatch currentBatch0() {
        return this.currentBatch;
    }

    public List<Expression> getProjects() {
        return this.projects;
    }

    private RowBatch projectBatch(RowBatch upstreamBatch) {
        ArrayList<Row> rows = new ArrayList<Row>(upstreamBatch.getRowCount());
        for (int i = 0; i < upstreamBatch.getRowCount(); ++i) {
            Row upstreamRow = upstreamBatch.getRow(i);
            Row row = this.projectRow(upstreamRow);
            rows.add(row);
        }
        return new ListRowBatch(rows);
    }

    private Row projectRow(Row upstreamRow) {
        HeapRow row = new HeapRow(this.projects.size());
        int colIdx = 0;
        for (Expression projection : this.projects) {
            Object projectionRes = projection.evalTop(upstreamRow, this.ctx);
            row.set(colIdx++, projectionRes);
        }
        return row;
    }
}

