/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.predicates.AbstractPredicate;
import com.hazelcast.query.impl.predicates.EqualPredicate;
import com.hazelcast.query.impl.predicates.NegatablePredicate;
import com.hazelcast.query.impl.predicates.PredicateUtils;
import com.hazelcast.query.impl.predicates.VisitablePredicate;
import com.hazelcast.query.impl.predicates.Visitor;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@BinaryInterface
public class NotEqualPredicate
extends AbstractPredicate
implements NegatablePredicate,
VisitablePredicate {
    private static final long serialVersionUID = 1L;
    Comparable value;

    public NotEqualPredicate() {
    }

    public NotEqualPredicate(String attribute, Comparable value) {
        super(attribute);
        this.value = value;
    }

    public Comparable getValue() {
        return this.value;
    }

    @Override
    public Predicate accept(Visitor visitor, Indexes indexes) {
        return visitor.visit(this, indexes);
    }

    @Override
    public boolean apply(Map.Entry mapEntry) {
        return !super.apply(mapEntry);
    }

    @Override
    protected boolean applyForSingleAttributeValue(Comparable attributeValue) {
        if (attributeValue == null) {
            return PredicateUtils.isNull(this.value);
        }
        this.value = this.convert(attributeValue, this.value);
        attributeValue = (Comparable)this.convertEnumValue(attributeValue);
        return Comparables.equal(attributeValue, this.value);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.value = (Comparable)in.readObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof NotEqualPredicate)) {
            return false;
        }
        NotEqualPredicate that = (NotEqualPredicate)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof NotEqualPredicate;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.attributeName + " != " + this.value;
    }

    @Override
    public Predicate negate() {
        return new EqualPredicate(this.attributeName, this.value);
    }

    @Override
    public int getClassId() {
        return 9;
    }
}

