/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.iterator;

import com.hazelcast.internal.util.ConstructorFunction;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AbstractMapQueryIterator<R>
implements Iterator<R> {
    private final ConstructorFunction<Integer, Iterator<R>> createPartitionIterator;
    private final int partitionCount;
    private Iterator<R> it;
    private int idx;

    public AbstractMapQueryIterator(ConstructorFunction<Integer, Iterator<R>> createPartitionIterator, int partitionCount) {
        this.createPartitionIterator = createPartitionIterator;
        this.partitionCount = partitionCount;
        this.idx = 0;
        this.it = createPartitionIterator.createNew(this.idx);
    }

    @Override
    public R next() {
        if (this.hasNext()) {
            return this.it.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        while (!this.it.hasNext()) {
            if (this.idx == this.partitionCount - 1) {
                return false;
            }
            this.it = this.createPartitionIterator.createNew(++this.idx);
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing when iterating map with query is not supported");
    }
}

