/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.networking.ChannelOptions;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.UnifiedProtocolDecoder;
import com.hazelcast.internal.server.tcp.UnifiedProtocolEncoder;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;

public class UnifiedChannelInitializer
implements ChannelInitializer {
    private final ServerContext serverContext;
    private final HazelcastProperties props;

    public UnifiedChannelInitializer(ServerContext serverContext) {
        this.props = serverContext.properties();
        this.serverContext = serverContext;
    }

    @Override
    public void initChannel(Channel channel) {
        ChannelOptions config = channel.options();
        config.setOption(ChannelOption.DIRECT_BUF, this.props.getBoolean(ClusterProperty.SOCKET_BUFFER_DIRECT)).setOption(ChannelOption.TCP_NODELAY, this.props.getBoolean(ClusterProperty.SOCKET_NO_DELAY)).setOption(ChannelOption.SO_KEEPALIVE, this.props.getBoolean(ClusterProperty.SOCKET_KEEP_ALIVE)).setOption(ChannelOption.SO_SNDBUF, this.props.getInteger(ClusterProperty.SOCKET_SEND_BUFFER_SIZE) * 1024).setOption(ChannelOption.SO_RCVBUF, this.props.getInteger(ClusterProperty.SOCKET_RECEIVE_BUFFER_SIZE) * 1024).setOption(ChannelOption.SO_LINGER, this.props.getSeconds(ClusterProperty.SOCKET_LINGER_SECONDS));
        UnifiedProtocolEncoder encoder = new UnifiedProtocolEncoder(this.serverContext);
        UnifiedProtocolDecoder decoder = new UnifiedProtocolDecoder(this.serverContext, encoder);
        channel.outboundPipeline().addLast(encoder);
        channel.inboundPipeline().addLast(decoder);
    }
}

