/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack.utils;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import shaded.org.eclipse.aether.artifact.Artifact;

public class Actions {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Stack Resolver");

    public static Action copy(Artifact artifact, File directory) {
        return () -> {
            Path source = artifact.getFile().toPath();
            Path output = directory.toPath().resolve(source.getFileName());
            LOGGER.info((Object)("Copying " + source.getFileName()));
            try {
                Files.copy(source, output, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Action skip(Artifact artifact) {
        return () -> LOGGER.info((Object)("Skipping " + artifact.toString()));
    }

    public static Action remove(File file) {
        return () -> {
            if (file.isFile()) {
                LOGGER.info((Object)("Deleting " + file.getName()));
                file.delete();
            }
        };
    }

    public static interface Action {
        public void execute();
    }
}

