require 'vertx/http_client_request'
require 'vertx/http_client_response'
require 'vertx/measured'
require 'vertx/multi_map'
require 'vertx/read_stream'
require 'vertx/web_socket'
require 'vertx/http_connection'
require 'vertx/future'
require 'vertx/socket_address'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.HttpClient
module Vertx
  #  An asynchronous HTTP client.
  #  <p>
  #  It allows you to make requests to HTTP servers, and a single client can make requests to any server.
  #  <p>
  #  It also allows you to open WebSockets to servers.
  #  <p>
  #  The client can also pool HTTP connections.
  #  <p>
  #  For pooling to occur, keep-alive must be true on the {Hash} (default is true).
  #  In this case connections will be pooled and re-used if there are pending HTTP requests waiting to get a connection,
  #  otherwise they will be closed.
  #  <p>
  #  This gives the benefits of keep alive when the client is loaded but means we don't keep connections hanging around
  #  unnecessarily when there would be no benefits anyway.
  #  <p>
  #  The client also supports pipe-lining of requests. Pipe-lining means another request is sent on the same connection
  #  before the response from the preceding one has returned. Pipe-lining is not appropriate for all requests.
  #  <p>
  #  To enable pipe-lining, it must be enabled on the {Hash} (default is false).
  #  <p>
  #  When pipe-lining is enabled the connection will be automatically closed when all in-flight responses have returned
  #  and there are no outstanding pending requests to write.
  #  <p>
  #  The client is designed to be reused between requests.
  class HttpClient
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::HttpClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::HttpClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HttpClient
    end
    def @@j_api_type.wrap(obj)
      HttpClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::HttpClient.java_class
    end
    #  Whether the metrics are enabled for this measured object
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
    end
    #  Like {::Vertx::HttpClient#request} using the <code>serverAddress</code> parameter to connect to the
    #  server instead of the <code>absoluteURI</code> parameter.
    #  <p>
    #  The request host header will still be created from the <code>host</code> and <code>port</code> parameters.
    #  <p>
    #  Use  to connect to a unix domain socket server.
    # @overload request(method,options)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Hash] options the request options
    # @overload request(method,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] requestURI the relative URI
    # @overload request(method,serverAddress,options)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Hash] options 
    # @overload request(method,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload request(method,options,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Hash] options the request options
    #   @yield 
    # @overload request(method,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload request(method,port,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload request(method,serverAddress,options,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Hash] options 
    #   @yield 
    # @overload request(method,host,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload request(method,serverAddress,port,host,requestURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Fixnum] port 
    #   @param [String] host 
    #   @param [String] requestURI 
    # @overload request(method,port,host,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload request(method,serverAddress,port,host,requestURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [Fixnum] port 
    #   @param [String] host 
    #   @param [String] requestURI 
    #   @yield 
    # @return [::Vertx::HttpClientRequest]
    def request(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil)
      if param_1.class == Symbol && param_2.class == Hash && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == String && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class.method_defined?(:j_del) && param_3.class == Hash && !block_given? && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2.j_del,Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == String && param_3.class == String && !block_given? && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == Hash && block_given? && param_3 == nil && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == String && block_given? && param_3 == nil && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == Fixnum && param_3.class == String && param_4.class == String && !block_given? && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2,param_3,param_4),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class.method_defined?(:j_del) && param_3.class == Hash && block_given? && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2.j_del,Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_3)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == String && param_3.class == String && block_given? && param_4 == nil && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class.method_defined?(:j_del) && param_3.class == Fixnum && param_4.class == String && param_5.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2.j_del,param_3,param_4,param_5),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == Fixnum && param_3.class == String && param_4.class == String && block_given? && param_5 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2,param_3,param_4,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class.method_defined?(:j_del) && param_3.class == Fixnum && param_4.class == String && param_5.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:request, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2.j_del,param_3,param_4,param_5,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling request(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5})"
    end
    #  Like {::Vertx::HttpClient#request_abs} using the <code>serverAddress</code> parameter to connect to the
    #  server instead of the <code>absoluteURI</code> parameter.
    #  <p>
    #  The request host header will still be created from the <code>absoluteURI</code> parameter.
    #  <p>
    #  Use  to connect to a unix domain socket server.
    # @overload requestAbs(method,absoluteURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] absoluteURI the absolute URI
    # @overload requestAbs(method,serverAddress,absoluteURI)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [String] absoluteURI 
    # @overload requestAbs(method,absoluteURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method
    #   @param [String] absoluteURI the absolute URI
    #   @yield the response handler
    # @overload requestAbs(method,serverAddress,absoluteURI,responseHandler)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method 
    #   @param [::Vertx::SocketAddress] serverAddress 
    #   @param [String] absoluteURI 
    #   @yield 
    # @return [::Vertx::HttpClientRequest]
    def request_abs(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Symbol && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class.method_defined?(:j_del) && param_3.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2.j_del,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class == String && block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Symbol && param_2.class.method_defined?(:j_del) && param_3.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:requestAbs, [Java::IoVertxCoreHttp::HttpMethod.java_class,Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(param_1.to_s),param_2.j_del,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling request_abs(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP GET request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload get(options)
    #   @param [Hash] options the request options
    # @overload get(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload get(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload get(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload get(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload get(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload get(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload get(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def get(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::Vertx::HttpClientRequest)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(param_1),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling get(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP GET request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @param [String] absoluteURI the absolute URI
    # @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def get_abs(absoluteURI=nil)
      if absoluteURI.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getAbs, [Java::java.lang.String.java_class]).call(absoluteURI),::Vertx::HttpClientRequest)
      elsif absoluteURI.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(absoluteURI,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling get_abs(#{absoluteURI})"
    end
    #  Sends an HTTP GET request to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload getNow(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload getNow(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload getNow(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload getNow(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [self]
    def get_now(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:getNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:getNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        @j_del.java_method(:getNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        @j_del.java_method(:getNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling get_now(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP POST request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload post(options)
    #   @param [Hash] options the request options
    # @overload post(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload post(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload post(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload post(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload post(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload post(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload post(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def post(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::Vertx::HttpClientRequest)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class]).call(param_1),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:post, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling post(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP POST request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @param [String] absoluteURI the absolute URI
    # @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def post_abs(absoluteURI=nil)
      if absoluteURI.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:postAbs, [Java::java.lang.String.java_class]).call(absoluteURI),::Vertx::HttpClientRequest)
      elsif absoluteURI.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:postAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(absoluteURI,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling post_abs(#{absoluteURI})"
    end
    #  Create an HTTP HEAD request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload head(options)
    #   @param [Hash] options the request options
    # @overload head(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload head(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload head(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload head(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload head(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload head(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload head(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def head(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::Vertx::HttpClientRequest)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class]).call(param_1),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:head, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling head(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP HEAD request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @param [String] absoluteURI the absolute URI
    # @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def head_abs(absoluteURI=nil)
      if absoluteURI.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headAbs, [Java::java.lang.String.java_class]).call(absoluteURI),::Vertx::HttpClientRequest)
      elsif absoluteURI.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(absoluteURI,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling head_abs(#{absoluteURI})"
    end
    #  Sends an HTTP HEAD request to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload headNow(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload headNow(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload headNow(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload headNow(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [self]
    def head_now(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:headNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:headNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        @j_del.java_method(:headNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        @j_del.java_method(:headNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling head_now(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP OPTIONS request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload options(options)
    #   @param [Hash] options the request options
    # @overload options(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload options(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload options(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload options(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload options(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload options(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload options(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def options(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::Vertx::HttpClientRequest)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class]).call(param_1),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:options, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling options(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP OPTIONS request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @param [String] absoluteURI the absolute URI
    # @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def options_abs(absoluteURI=nil)
      if absoluteURI.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:optionsAbs, [Java::java.lang.String.java_class]).call(absoluteURI),::Vertx::HttpClientRequest)
      elsif absoluteURI.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:optionsAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(absoluteURI,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling options_abs(#{absoluteURI})"
    end
    #  Sends an HTTP OPTIONS request to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload optionsNow(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload optionsNow(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload optionsNow(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload optionsNow(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [self]
    def options_now(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:optionsNow, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:optionsNow, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        @j_del.java_method(:optionsNow, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        @j_del.java_method(:optionsNow, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling options_now(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP PUT request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload put(options)
    #   @param [Hash] options the request options
    # @overload put(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload put(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload put(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload put(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload put(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload put(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload put(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def put(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::Vertx::HttpClientRequest)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class]).call(param_1),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:put, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling put(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP PUT request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @param [String] absoluteURI the absolute URI
    # @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def put_abs(absoluteURI=nil)
      if absoluteURI.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:putAbs, [Java::java.lang.String.java_class]).call(absoluteURI),::Vertx::HttpClientRequest)
      elsif absoluteURI.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:putAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(absoluteURI,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling put_abs(#{absoluteURI})"
    end
    #  Create an HTTP DELETE request to send to the server at the specified host and port, specifying a response handler to receive
    #  the response
    # @overload delete(options)
    #   @param [Hash] options the request options
    # @overload delete(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload delete(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload delete(options,responseHandler)
    #   @param [Hash] options the request options
    #   @yield the response handler
    # @overload delete(requestURI,responseHandler)
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload delete(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload delete(host,requestURI,responseHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @overload delete(port,host,requestURI,responseHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def delete(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::Vertx::HttpClientRequest)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class]).call(param_1),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2),::Vertx::HttpClientRequest)
      elsif param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3),::Vertx::HttpClientRequest)
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:delete, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling delete(#{param_1},#{param_2},#{param_3})"
    end
    #  Create an HTTP DELETE request to send to the server using an absolute URI, specifying a response handler to receive
    #  the response
    # @param [String] absoluteURI the absolute URI
    # @yield the response handler
    # @return [::Vertx::HttpClientRequest] an HTTP client request object
    def delete_abs(absoluteURI=nil)
      if absoluteURI.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deleteAbs, [Java::java.lang.String.java_class]).call(absoluteURI),::Vertx::HttpClientRequest)
      elsif absoluteURI.class == String && block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:deleteAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(absoluteURI,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)) })),::Vertx::HttpClientRequest)
      end
      raise ArgumentError, "Invalid arguments when calling delete_abs(#{absoluteURI})"
    end
    #  Connect a WebSocket to the specified port, host and relative request URI, with the specified headers, using
    #  the specified version of WebSockets, and the specified WebSocket sub protocols
    # @overload websocket(options,wsConnect)
    #   @param [Hash] options the request options
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(requestURI,wsConnect)
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(options,wsConnect,failureHandler)
    #   @param [Hash] options the request options
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(host,requestURI,wsConnect)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(options,headers,wsConnect)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(requestURI,wsConnect,failureHandler)
    #   @param [String] requestURI the relative URI
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(requestURI,headers,wsConnect)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(port,host,requestURI,wsConnect)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(host,requestURI,wsConnect,failureHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(options,headers,wsConnect,failureHandler)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(host,requestURI,headers,wsConnect)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(options,headers,version,wsConnect)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(requestURI,headers,wsConnect,failureHandler)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(requestURI,headers,version,wsConnect)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(port,host,requestURI,wsConnect,failureHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(port,host,requestURI,headers,wsConnect)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(host,requestURI,headers,wsConnect,failureHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(options,headers,version,wsConnect,failureHandler)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(host,requestURI,headers,version,wsConnect)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(options,headers,version,subProtocols,wsConnect)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(requestURI,headers,version,wsConnect,failureHandler)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(requestURI,headers,version,subProtocols,wsConnect)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(port,host,requestURI,headers,wsConnect,failureHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(port,host,requestURI,headers,version,wsConnect)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(host,requestURI,headers,version,wsConnect,failureHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(options,headers,version,subProtocols,wsConnect,failureHandler)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(host,requestURI,headers,version,subProtocols,wsConnect)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(requestURI,headers,version,subProtocols,wsConnect,failureHandler)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(port,host,requestURI,headers,version,wsConnect,failureHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(port,host,requestURI,headers,version,subProtocols,wsConnect)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    #   @yield handler that will be called with the WebSocket when connected
    # @overload websocket(host,requestURI,headers,version,subProtocols,wsConnect,failureHandler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @overload websocket(port,host,requestURI,headers,version,subProtocols,wsConnect,failureHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    #   @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    #   @yield handler that will be called if WebSocket connection fails
    # @return [self]
    def websocket(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil,param_7=nil)
      if param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == Hash && param_2.class == Proc && block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |event| param_2.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class == Proc && block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| param_2.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2.j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given? && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class == String && param_3.class == Proc && block_given? && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |event| param_3.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && param_3.class == Proc && block_given? && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,(Proc.new { |event| param_3.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && block_given? && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3.j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && block_given? && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && param_3.class == Proc && block_given? && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2.j_del,(Proc.new { |event| param_3.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && block_given? && param_4 == nil && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class == Proc && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |event| param_4.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,param_4.j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && param_4.class == Proc && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3.j_del,(Proc.new { |event| param_4.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == Proc && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),(Proc.new { |event| param_4.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && param_4.class == Symbol && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_4.to_s),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == String && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),param_4,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == Proc && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),(Proc.new { |event| param_4.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == String && block_given? && param_5 == nil && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),param_4,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && param_5.class == Proc && block_given? && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,param_4.j_del,(Proc.new { |event| param_5.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && param_5.class == Symbol && block_given? && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,param_4.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_5.to_s),(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && param_4.class == Symbol && param_5.class == Proc && block_given? && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_4.to_s),(Proc.new { |event| param_5.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == String && param_5.class == Proc && block_given? && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),param_4,(Proc.new { |event| param_5.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && param_4.class == Symbol && param_5.class == String && block_given? && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_4.to_s),param_5,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == String && param_5.class == Proc && block_given? && param_6 == nil && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),param_4,(Proc.new { |event| param_5.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && param_5.class == Symbol && param_6.class == Proc && block_given? && param_7 == nil
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,param_4.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_5.to_s),(Proc.new { |event| param_6.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && param_5.class == Symbol && param_6.class == String && block_given? && param_7 == nil
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,param_4.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_5.to_s),param_6,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }))
        return self
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && param_4.class == Symbol && param_5.class == String && param_6.class == Proc && block_given? && param_7 == nil
        @j_del.java_method(:websocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_4.to_s),param_5,(Proc.new { |event| param_6.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && param_5.class == Symbol && param_6.class == String && param_7.class == Proc && block_given?
        @j_del.java_method(:websocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,param_4.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_5.to_s),param_6,(Proc.new { |event| param_7.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling websocket(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6},#{param_7})"
    end
    #  Connect a WebSocket with the specified absolute url, with the specified headers, using
    #  the specified version of WebSockets, and the specified WebSocket sub protocols.
    # @param [String] url the absolute url
    # @param [::Vertx::MultiMap] headers the headers
    # @param [:V00,:V07,:V08,:V13] version the WebSocket version
    # @param [String] subProtocols the subprotocols to use
    # @param [Proc] wsConnect handler that will be called with the WebSocket when connected
    # @yield handler that will be called if WebSocket connection fails
    # @return [self]
    def websocket_abs(url=nil,headers=nil,version=nil,subProtocols=nil,wsConnect=nil)
      if url.class == String && headers.class.method_defined?(:j_del) && version.class == Symbol && subProtocols.class == String && wsConnect.class == Proc && block_given?
        @j_del.java_method(:websocketAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(url,headers.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(version.to_s),subProtocols,(Proc.new { |event| wsConnect.call(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocket)) }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling websocket_abs(#{url},#{headers},#{version},#{subProtocols},#{wsConnect})"
    end
    #  Connect a WebSocket to the specified port, host and relative request URI
    # @overload webSocket(requestURI,handler)
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the WebSocket when connected
    # @overload webSocket(options,handler)
    #   @param [Hash] options the request options
    #   @yield 
    # @overload webSocket(host,requestURI,handler)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the WebSocket when connected
    # @overload webSocket(port,host,requestURI,handler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @yield handler that will be called with the WebSocket when connected
    # @return [void]
    def web_socket(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        return @j_del.java_method(:webSocket, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) }))
      elsif param_1.class == Hash && block_given? && param_2 == nil && param_3 == nil
        return @j_del.java_method(:webSocket, [Java::IoVertxCoreHttp::WebSocketConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxCoreHttp::WebSocketConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) }))
      elsif param_1.class == String && param_2.class == String && block_given? && param_3 == nil
        return @j_del.java_method(:webSocket, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) }))
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        return @j_del.java_method(:webSocket, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling web_socket(#{param_1},#{param_2},#{param_3})"
    end
    #  Connect a WebSocket with the specified absolute url, with the specified headers, using
    #  the specified version of WebSockets, and the specified WebSocket sub protocols.
    # @param [String] url the absolute url
    # @param [::Vertx::MultiMap] headers the headers
    # @param [:V00,:V07,:V08,:V13] version the WebSocket version
    # @param [Array<String>] subProtocols the subprotocols to use
    # @yield handler that will be called if WebSocket connection fails
    # @return [void]
    def web_socket_abs(url=nil,headers=nil,version=nil,subProtocols=nil)
      if url.class == String && headers.class.method_defined?(:j_del) && version.class == Symbol && subProtocols.class == Array && block_given?
        return @j_del.java_method(:webSocketAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(url,headers.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(version.to_s),subProtocols.map { |element| element },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::WebSocket) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling web_socket_abs(#{url},#{headers},#{version},#{subProtocols})"
    end
    #  Create a WebSocket stream to the specified port, host and relative request URI, with the specified headers, using
    #  the specified version of WebSockets, and the specified WebSocket sub protocols
    # @overload websocketStream(options)
    #   @param [Hash] options the request options
    # @overload websocketStream(requestURI)
    #   @param [String] requestURI the relative URI
    # @overload websocketStream(host,requestURI)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload websocketStream(options,headers)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    # @overload websocketStream(requestURI,headers)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    # @overload websocketStream(port,host,requestURI)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    # @overload websocketStream(host,requestURI,headers)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    # @overload websocketStream(options,headers,version)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    # @overload websocketStream(requestURI,headers,version)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    # @overload websocketStream(port,host,requestURI,headers)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    # @overload websocketStream(host,requestURI,headers,version)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    # @overload websocketStream(options,headers,version,subProtocols)
    #   @param [Hash] options the request options
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    # @overload websocketStream(requestURI,headers,version,subProtocols)
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols
    # @overload websocketStream(port,host,requestURI,headers,version)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    # @overload websocketStream(host,requestURI,headers,version,subProtocols)
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    # @overload websocketStream(port,host,requestURI,headers,version,subProtocols)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] requestURI the relative URI
    #   @param [::Vertx::MultiMap] headers the headers
    #   @param [:V00,:V07,:V08,:V13] version the WebSocket version
    #   @param [String] subProtocols the subprotocols to use
    # @return [::Vertx::ReadStream] a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
    def websocket_stream(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::IoVertxCoreHttp::RequestOptions.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class]).call(param_1),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && param_2.class == String && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class]).call(param_1,param_2.j_del),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && !block_given? && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && !block_given? && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class]).call(param_1,param_2,param_3.j_del),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && !block_given? && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s)),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && !block_given? && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class]).call(param_1,param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s)),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class]).call(param_1,param_2,param_3,param_4.j_del),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && param_4.class == Symbol && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class]).call(param_1,param_2,param_3.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_4.to_s)),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == Hash && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == String && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::IoVertxCoreHttp::RequestOptions.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class]).call(Java::IoVertxCoreHttp::RequestOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),param_4),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && param_2.class.method_defined?(:j_del) && param_3.class == Symbol && param_4.class == String && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class]).call(param_1,param_2.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_3.to_s),param_4),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && param_5.class == Symbol && !block_given? && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class]).call(param_1,param_2,param_3,param_4.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_5.to_s)),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == String && param_2.class == String && param_3.class.method_defined?(:j_del) && param_4.class == Symbol && param_5.class == String && !block_given? && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_4.to_s),param_5),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && param_4.class.method_defined?(:j_del) && param_5.class == Symbol && param_6.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStream, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class]).call(param_1,param_2,param_3,param_4.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(param_5.to_s),param_6),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling websocket_stream(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    #  Create a WebSocket stream with the specified absolute url, the specified headers, using the specified version of WebSockets,
    #  and the specified WebSocket sub protocols.
    # @param [String] url the absolute url
    # @param [::Vertx::MultiMap] headers the headers
    # @param [:V00,:V07,:V08,:V13] version the WebSocket version
    # @param [String] subProtocols the subprotocols to use
    # @return [::Vertx::ReadStream] a stream emitting a WebSocket event when the client connection has been upgraded to a WebSocket
    def websocket_stream_abs(url=nil,headers=nil,version=nil,subProtocols=nil)
      if url.class == String && headers.class.method_defined?(:j_del) && version.class == Symbol && subProtocols.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:websocketStreamAbs, [Java::java.lang.String.java_class,Java::IoVertxCore::MultiMap.java_class,Java::IoVertxCoreHttp::WebsocketVersion.java_class,Java::java.lang.String.java_class]).call(url,headers.j_del,Java::IoVertxCoreHttp::WebsocketVersion.valueOf(version.to_s),subProtocols),::Vertx::ReadStreamImpl,::Vertx::WebSocket.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling websocket_stream_abs(#{url},#{headers},#{version},#{subProtocols})"
    end
    #  Set a connection handler for the client. This handler is called when a new connection is established.
    # @yield 
    # @return [self]
    def connection_handler
      if block_given?
        @j_del.java_method(:connectionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpConnection)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connection_handler()"
    end
    #  Set a redirect handler for the http client.
    #  <p>
    #  The redirect handler is called when a <code>3xx</code> response is received and the request is configured to
    #  follow redirects with {::Vertx::HttpClientRequest#set_follow_redirects}.
    #  <p>
    #  The redirect handler is passed the {::Vertx::HttpClientResponse}, it can return an {::Vertx::HttpClientRequest} or <code>null</code>.
    #  <ul>
    #    <li>when null is returned, the original response is processed by the original request response handler</li>
    #    <li>when a new <code>Future<HttpClientRequest></code> is returned, the client will send this new request</li>
    #  </ul>
    #  The new request will get a copy of the previous request headers unless headers are set. In this case,
    #  the client assumes that the redirect handler exclusively managers the headers of the new request.
    #  <p>
    #  The handler must return a <code>Future<HttpClientRequest></code> unsent so the client can further configure it and send it.
    # @yield the new redirect handler
    # @return [self]
    def redirect_handler(handler=nil)
      if block_given? && handler == nil
        @j_del.java_method(:redirectHandler, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::HttpClientResponse)).j_del }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling redirect_handler(#{handler})"
    end
    #  Close the client. Closing will close down any pooled connections.
    #  Clients should always be closed after use.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
