require 'vertx-sql-client/sql_client'
require 'vertx-sql-client/query'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/prepared_statement'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Transaction
module VertxSqlClient
  #  A transaction that allows to control the transaction and receive events.
  class Transaction < ::VertxSqlClient::SqlClient
    # @private
    # @param j_del [::VertxSqlClient::Transaction] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Transaction] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Transaction
    end
    def @@j_api_type.wrap(obj)
      Transaction.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Transaction.java_class
    end
    #  Create a query, the {::VertxSqlClient::Query#execute} method must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::Query] the query
    def query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:query, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::Query,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  Create a prepared query, one of the {::VertxSqlClient::Query#execute} or {::VertxSqlClient::PreparedQuery#execute_batch}
    #  methods must be called to execute the query.
    # @param [String] sql 
    # @return [::VertxSqlClient::PreparedQuery] the prepared query
    def prepared_query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql})"
    end
    #  Create a prepared query.
    # @param [String] sql the sql
    # @yield the handler notified with the prepared query asynchronously
    # @return [self]
    def prepare(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedStatement) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepare(#{sql})"
    end
    #  Like {::VertxSqlClient::Transaction#commit} with an handler to be notified when the transaction commit has completed
    # @yield 
    # @return [void]
    def commit
      if !block_given?
        return @j_del.java_method(:commit, []).call()
      elsif block_given?
        return @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling commit()"
    end
    #  Like {::VertxSqlClient::Transaction#rollback} with an handler to be notified when the transaction rollback has completed
    # @yield 
    # @return [void]
    def rollback
      if !block_given?
        return @j_del.java_method(:rollback, []).call()
      elsif block_given?
        return @j_del.java_method(:rollback, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling rollback()"
    end
    #  Set an handler to be called when the transaction is aborted.
    # @yield the handler
    # @return [self]
    def abort_handler
      if block_given?
        @j_del.java_method(:abortHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling abort_handler()"
    end
    #  Rollback the transaction and release the associated resources.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
