require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.PropertyKind
module VertxSqlClient
  #  Represents which kind the property is.
  class PropertyKind
    # @private
    # @param j_del [::VertxSqlClient::PropertyKind] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxSqlClient::PropertyKind] the underlying java delegate
    def j_del
      @j_del
    end
    # @param [String] name 
    # @param [Nil] type 
    # @return [::VertxSqlClient::PropertyKind] a property kind matching the provided <code>name</code>, the <code>type</code> can be used to check the property value type or cast it to the expected type
    def self.create(name=nil,type=nil)
      if name.class == String && type.class == Class && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::PropertyKind.java_method(:create, [Java::java.lang.String.java_class,Java::JavaLang::Class.java_class]).call(name,::Vertx::Util::Utils.j_class_of(type)),::VertxSqlClient::PropertyKind, ::Vertx::Util::Utils.v_type_of(type))
      end
      raise ArgumentError, "Invalid arguments when calling create(#{name},#{type})"
    end
    # @return [String] the property name
    def name
      if !block_given?
        return @j_del.java_method(:name, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling name()"
    end
  end
end
