require 'vertx-sql-client/query'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.PreparedQuery
module VertxSqlClient
  #  A query for a prepared statement allowing parameterized execution of the query, this query will use
  #  a prepared statement.
  class PreparedQuery < ::VertxSqlClient::Query
    # @private
    # @param j_del [::VertxSqlClient::PreparedQuery] the java delegate
    def initialize(j_del, j_arg_T=nil)
      super(j_del, j_arg_T)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxSqlClient::PreparedQuery] the underlying java delegate
    def j_del
      @j_del
    end
    #  Execute the query.
    # @param [::VertxSqlClient::Tuple] tuple 
    # @yield the handler receiving the response
    # @return [void]
    def execute(tuple=nil)
      if block_given? && tuple == nil
        return @j_del.java_method(:execute, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) }))
      elsif tuple.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:execute, [Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(tuple.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling execute(#{tuple})"
    end
    #  Execute the query with a batch of tuples.
    # @param [Array<::VertxSqlClient::Tuple>] batch the batch of tuples
    # @yield the handler receiving the response
    # @return [void]
    def execute_batch(batch=nil)
      if batch.class == Array && block_given?
        return @j_del.java_method(:executeBatch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling execute_batch(#{batch})"
    end
    #  Use the specified <code>mapper</code> for mapping {::VertxSqlClient::Row} to <code><U></code>.
    # @yield 
    # @return [::VertxSqlClient::PreparedQuery]
    def mapping(mapper=nil)
      if block_given? && mapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:mapping, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::VertxSqlClient::Row))) })),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling mapping(#{mapper})"
    end
  end
end
