require 'vertx-amqp-client/amqp_message'
require 'vertx/pipe'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx-amqp-client/amqp_connection'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpReceiver
module VertxAmqpClient
  #  Interface used to consume AMQP message as a stream of message.
  #  Back pressure is implemented using AMQP credits.
  class AmqpReceiver
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxAmqpClient::AmqpReceiver] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpReceiver] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpReceiver
    end
    def @@j_api_type.wrap(obj)
      AmqpReceiver.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpReceiver.java_class
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::VertxAmqpClient::AmqpMessage.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class]).call(dst.j_del)
      elsif dst.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxAmqpClient::AmqpMessage)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    #  The listened address.
    # @return [String] the address, not <code>null</code>
    def address
      if !block_given?
        if @cached_address != nil
          return @cached_address
        end
        return @cached_address = @j_del.java_method(:address, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling address()"
    end
    #  Closes the receiver.
    # @yield handler called when the receiver has been closed, can be <code>null</code>
    # @return [void]
    def close
      if block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Gets the connection having created the receiver. Cannot be <code>null</code>
    # @return [::VertxAmqpClient::AmqpConnection] the connection having created the receiver.
    def connection
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connection, []).call(),::VertxAmqpClient::AmqpConnection)
      end
      raise ArgumentError, "Invalid arguments when calling connection()"
    end
  end
end
