/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/chain_auth */
var utils = require('vertx-js/util/utils');
var AuthProvider = require('vertx-auth-common-js/auth_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JChainAuth = Java.type('io.vertx.ext.auth.ChainAuth');

/**
 Chain several auth providers as if they were one. This is useful for cases where one want to authenticate across
 several providers, for example, database and fallback to passwd file.

 @class
*/
var ChainAuth = function(j_val) {

  var j_chainAuth = j_val;
  var that = this;
  AuthProvider.call(this, j_val);

  var __super_create = this.create;
  var __super_append = this.append;
  var __super_remove = this.remove;
  var __super_clear = this.clear;
  /**
   Appends a auth provider to the chain.

   @public
   @param other {AuthProvider} auth provider 
   @return {ChainAuth} self
   */
  this.append =  function(other) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_chainAuth["append(io.vertx.ext.auth.AuthProvider)"](__args[0]._jdel) ;
      return that;
    } else if (typeof __super_append != 'undefined') {
      return __super_append.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Removes a provider from the chain.

   @public
   @param other {AuthProvider} provider to remove 
   @return {boolean} true if provider was removed, false if non existent in the chain.
   */
  this.remove =  function(other) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return j_chainAuth["remove(io.vertx.ext.auth.AuthProvider)"](__args[0]._jdel) ;
    } else if (typeof __super_remove != 'undefined') {
      return __super_remove.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Clears the chain.

   @public

   */
  this.clear =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_chainAuth["clear()"]();
    } else if (typeof __super_clear != 'undefined') {
      return __super_clear.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_chainAuth;
};

ChainAuth._jclass = utils.getJavaClass("io.vertx.ext.auth.ChainAuth");
ChainAuth._jtype = {accept: function(obj) {
    return ChainAuth._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ChainAuth.prototype, {});
    ChainAuth.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ChainAuth._create = function(jdel) {var obj = Object.create(ChainAuth.prototype, {});
  ChainAuth.apply(obj, arguments);
  return obj;
}
/**
 Create a Chainable Auth Provider auth provider

 @memberof module:vertx-auth-common-js/chain_auth

 @return {ChainAuth} the auth provider
 */
ChainAuth.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(ChainAuth, JChainAuth["create()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = ChainAuth;