/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-amqp-client-js/amqp_message_builder */
var utils = require('vertx-js/util/utils');
var AmqpMessage = require('vertx-amqp-client-js/amqp_message');
var Buffer = require('vertx-js/buffer');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JAmqpMessageBuilder = Java.type('io.vertx.amqp.AmqpMessageBuilder');

/**

 @class
*/
var AmqpMessageBuilder = function(j_val) {

  var j_amqpMessageBuilder = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_build = this.build;
  var __super_priority = this.priority;
  var __super_durable = this.durable;
  var __super_ttl = this.ttl;
  var __super_firstAcquirer = this.firstAcquirer;
  var __super_deliveryCount = this.deliveryCount;
  var __super_id = this.id;
  var __super_address = this.address;
  var __super_replyTo = this.replyTo;
  var __super_correlationId = this.correlationId;
  var __super_withBody = this.withBody;
  var __super_withSymbolAsBody = this.withSymbolAsBody;
  var __super_subject = this.subject;
  var __super_contentType = this.contentType;
  var __super_contentEncoding = this.contentEncoding;
  var __super_expiryTime = this.expiryTime;
  var __super_creationTime = this.creationTime;
  var __super_groupId = this.groupId;
  var __super_replyToGroupId = this.replyToGroupId;
  var __super_applicationProperties = this.applicationProperties;
  var __super_withBooleanAsBody = this.withBooleanAsBody;
  var __super_withByteAsBody = this.withByteAsBody;
  var __super_withShortAsBody = this.withShortAsBody;
  var __super_withIntegerAsBody = this.withIntegerAsBody;
  var __super_withLongAsBody = this.withLongAsBody;
  var __super_withFloatAsBody = this.withFloatAsBody;
  var __super_withDoubleAsBody = this.withDoubleAsBody;
  var __super_withCharAsBody = this.withCharAsBody;
  var __super_withBufferAsBody = this.withBufferAsBody;
  var __super_withJsonObjectAsBody = this.withJsonObjectAsBody;
  var __super_withJsonArrayAsBody = this.withJsonArrayAsBody;
  /**

   @public

   @return {AmqpMessage} the message.
   */
  this.build =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(AmqpMessage, j_amqpMessageBuilder["build()"]()) ;
    } else if (typeof __super_build != 'undefined') {
      return __super_build.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param priority {number} 
   @return {AmqpMessageBuilder}
   */
  this.priority =  function(priority) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["priority(short)"](__args[0])) ;
    } else if (typeof __super_priority != 'undefined') {
      return __super_priority.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param durable {boolean} 
   @return {AmqpMessageBuilder}
   */
  this.durable =  function(durable) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["durable(boolean)"](__args[0])) ;
    } else if (typeof __super_durable != 'undefined') {
      return __super_durable.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param ttl {number} 
   @return {AmqpMessageBuilder}
   */
  this.ttl =  function(ttl) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["ttl(long)"](__args[0])) ;
    } else if (typeof __super_ttl != 'undefined') {
      return __super_ttl.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param first {boolean} 
   @return {AmqpMessageBuilder}
   */
  this.firstAcquirer =  function(first) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["firstAcquirer(boolean)"](__args[0])) ;
    } else if (typeof __super_firstAcquirer != 'undefined') {
      return __super_firstAcquirer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param count {number} 
   @return {AmqpMessageBuilder}
   */
  this.deliveryCount =  function(count) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["deliveryCount(int)"](__args[0])) ;
    } else if (typeof __super_deliveryCount != 'undefined') {
      return __super_deliveryCount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @return {AmqpMessageBuilder}
   */
  this.id =  function(id) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["id(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_id != 'undefined') {
      return __super_id.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param address {string} 
   @return {AmqpMessageBuilder}
   */
  this.address =  function(address) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["address(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_address != 'undefined') {
      return __super_address.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param replyTo {string} 
   @return {AmqpMessageBuilder}
   */
  this.replyTo =  function(replyTo) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["replyTo(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_replyTo != 'undefined') {
      return __super_replyTo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param correlationId {string} 
   @return {AmqpMessageBuilder}
   */
  this.correlationId =  function(correlationId) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["correlationId(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_correlationId != 'undefined') {
      return __super_correlationId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param value {string} 
   @return {AmqpMessageBuilder}
   */
  this.withBody =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withBody(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_withBody != 'undefined') {
      return __super_withBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param value {string} 
   @return {AmqpMessageBuilder}
   */
  this.withSymbolAsBody =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withSymbolAsBody(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_withSymbolAsBody != 'undefined') {
      return __super_withSymbolAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param subject {string} 
   @return {AmqpMessageBuilder}
   */
  this.subject =  function(subject) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["subject(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_subject != 'undefined') {
      return __super_subject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param ct {string} 
   @return {AmqpMessageBuilder}
   */
  this.contentType =  function(ct) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["contentType(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_contentType != 'undefined') {
      return __super_contentType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param ct {string} 
   @return {AmqpMessageBuilder}
   */
  this.contentEncoding =  function(ct) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["contentEncoding(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_contentEncoding != 'undefined') {
      return __super_contentEncoding.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expiry {number} 
   @return {AmqpMessageBuilder}
   */
  this.expiryTime =  function(expiry) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["expiryTime(long)"](__args[0])) ;
    } else if (typeof __super_expiryTime != 'undefined') {
      return __super_expiryTime.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param ct {number} 
   @return {AmqpMessageBuilder}
   */
  this.creationTime =  function(ct) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["creationTime(long)"](__args[0])) ;
    } else if (typeof __super_creationTime != 'undefined') {
      return __super_creationTime.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param gi {string} 
   @return {AmqpMessageBuilder}
   */
  this.groupId =  function(gi) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["groupId(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_groupId != 'undefined') {
      return __super_groupId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param rt {string} 
   @return {AmqpMessageBuilder}
   */
  this.replyToGroupId =  function(rt) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["replyToGroupId(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_replyToGroupId != 'undefined') {
      return __super_replyToGroupId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param props {Object} 
   @return {AmqpMessageBuilder}
   */
  this.applicationProperties =  function(props) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["applicationProperties(io.vertx.core.json.JsonObject)"](utils.convParamJsonObject(__args[0]))) ;
    } else if (typeof __super_applicationProperties != 'undefined') {
      return __super_applicationProperties.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param v {boolean} 
   @return {AmqpMessageBuilder}
   */
  this.withBooleanAsBody =  function(v) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withBooleanAsBody(boolean)"](__args[0])) ;
    } else if (typeof __super_withBooleanAsBody != 'undefined') {
      return __super_withBooleanAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param v {number} 
   @return {AmqpMessageBuilder}
   */
  this.withByteAsBody =  function(v) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withByteAsBody(byte)"](__args[0])) ;
    } else if (typeof __super_withByteAsBody != 'undefined') {
      return __super_withByteAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param v {number} 
   @return {AmqpMessageBuilder}
   */
  this.withShortAsBody =  function(v) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withShortAsBody(short)"](__args[0])) ;
    } else if (typeof __super_withShortAsBody != 'undefined') {
      return __super_withShortAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param v {number} 
   @return {AmqpMessageBuilder}
   */
  this.withIntegerAsBody =  function(v) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withIntegerAsBody(int)"](__args[0])) ;
    } else if (typeof __super_withIntegerAsBody != 'undefined') {
      return __super_withIntegerAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param v {number} 
   @return {AmqpMessageBuilder}
   */
  this.withLongAsBody =  function(v) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withLongAsBody(long)"](__args[0])) ;
    } else if (typeof __super_withLongAsBody != 'undefined') {
      return __super_withLongAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param v {number} 
   @return {AmqpMessageBuilder}
   */
  this.withFloatAsBody =  function(v) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withFloatAsBody(float)"](__args[0])) ;
    } else if (typeof __super_withFloatAsBody != 'undefined') {
      return __super_withFloatAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param v {number} 
   @return {AmqpMessageBuilder}
   */
  this.withDoubleAsBody =  function(v) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withDoubleAsBody(double)"](__args[0])) ;
    } else if (typeof __super_withDoubleAsBody != 'undefined') {
      return __super_withDoubleAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param c {string} 
   @return {AmqpMessageBuilder}
   */
  this.withCharAsBody =  function(c) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='string') {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withCharAsBody(char)"](__args[0])) ;
    } else if (typeof __super_withCharAsBody != 'undefined') {
      return __super_withCharAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param buffer {Buffer} 
   @return {AmqpMessageBuilder}
   */
  this.withBufferAsBody =  function(buffer) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withBufferAsBody(io.vertx.core.buffer.Buffer)"](__args[0]._jdel)) ;
    } else if (typeof __super_withBufferAsBody != 'undefined') {
      return __super_withBufferAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param json {Object} 
   @return {AmqpMessageBuilder}
   */
  this.withJsonObjectAsBody =  function(json) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withJsonObjectAsBody(io.vertx.core.json.JsonObject)"](utils.convParamJsonObject(__args[0]))) ;
    } else if (typeof __super_withJsonObjectAsBody != 'undefined') {
      return __super_withJsonObjectAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param json {Array} 
   @return {AmqpMessageBuilder}
   */
  this.withJsonArrayAsBody =  function(json) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return utils.convReturnVertxGen(AmqpMessageBuilder, j_amqpMessageBuilder["withJsonArrayAsBody(io.vertx.core.json.JsonArray)"](utils.convParamJsonArray(__args[0]))) ;
    } else if (typeof __super_withJsonArrayAsBody != 'undefined') {
      return __super_withJsonArrayAsBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_amqpMessageBuilder;
};

AmqpMessageBuilder._jclass = utils.getJavaClass("io.vertx.amqp.AmqpMessageBuilder");
AmqpMessageBuilder._jtype = {accept: function(obj) {
    return AmqpMessageBuilder._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AmqpMessageBuilder.prototype, {});
    AmqpMessageBuilder.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AmqpMessageBuilder._create = function(jdel) {var obj = Object.create(AmqpMessageBuilder.prototype, {});
  AmqpMessageBuilder.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-amqp-client-js/amqp_message_builder

 @return {AmqpMessageBuilder} a new instance of {@link AmqpMessageBuilder}
 */
AmqpMessageBuilder.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(AmqpMessageBuilder, JAmqpMessageBuilder["create()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AmqpMessageBuilder;