/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\nH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\n\u00a8\u0006\f"}, d2={"isCoroutineCallWithAdditionalInference", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getCoroutineInferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceData;", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "isResultWithCoroutineInference", "frontend"})
public final class CoroutineInferenceUtilKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCoroutineCallWithAdditionalInference(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            if (!AnnotationsForResolveKt.hasBuilderInferenceAnnotation(parameterDescriptor)) return false;
            if (!CoroutineUtilKt.getHasFunctionOrSuspendFunctionType(parameterDescriptor)) return false;
            bl = true;
        } else {
            bl = CoroutineUtilKt.getHasSuspendFunctionType(parameterDescriptor);
        }
        boolean parameterHasOptIn = bl;
        if (!parameterHasOptIn) return false;
        if (!(argument.getArgumentExpression() instanceof KtLambdaExpression)) return false;
        KotlinType kotlinType2 = parameterDescriptor.getType();
        boolean bl2 = false;
        boolean bl3 = false;
        KotlinType it = kotlinType2;
        boolean bl4 = false;
        KotlinType kotlinType3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"it");
        if (!FunctionTypesKt.isBuiltinFunctionalType(kotlinType3)) return false;
        if (FunctionTypesKt.getReceiverTypeFromFunctionType(it) == null) return false;
        return true;
    }

    public static final boolean isResultWithCoroutineInference(@NotNull OverloadResolutionResultsImpl<?> $this$isResultWithCoroutineInference) {
        Intrinsics.checkParameterIsNotNull($this$isResultWithCoroutineInference, (String)"$this$isResultWithCoroutineInference");
        return CoroutineInferenceUtilKt.getCoroutineInferenceData($this$isResultWithCoroutineInference) != null;
    }

    private static final CoroutineInferenceData getCoroutineInferenceData(@NotNull OverloadResolutionResultsImpl<?> $this$getCoroutineInferenceData) {
        if (!$this$getCoroutineInferenceData.isSingleResult()) {
            return null;
        }
        getCoroutineInferenceData.1 $fun$getData$1 = getCoroutineInferenceData.1.INSTANCE;
        ResolvedCall resolvedCall2 = $this$getCoroutineInferenceData.getResultingCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"resultingCall");
        CoroutineInferenceData coroutineInferenceData = $fun$getData$1.invoke(resolvedCall2.getDispatchReceiver());
        if (coroutineInferenceData == null) {
            ResolvedCall resolvedCall3 = $this$getCoroutineInferenceData.getResultingCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall3, (String)"resultingCall");
            coroutineInferenceData = $fun$getData$1.invoke(resolvedCall3.getExtensionReceiver());
        }
        return coroutineInferenceData;
    }

    public static final /* synthetic */ CoroutineInferenceData access$getCoroutineInferenceData(OverloadResolutionResultsImpl $this$access_u24getCoroutineInferenceData) {
        return CoroutineInferenceUtilKt.getCoroutineInferenceData($this$access_u24getCoroutineInferenceData);
    }
}

