/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICompletableFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.spi.cluster.hazelcast.impl.HandlerCallBackAdapter;
import io.vertx.spi.cluster.hazelcast.impl.VertxExecutorAdapter;
import java.util.Objects;
import java.util.concurrent.Executor;

public class HazelcastInternalAsyncCounter
implements Counter {
    private final IAtomicLong atomicLong;
    private final Vertx vertx;

    public HazelcastInternalAsyncCounter(Vertx vertx, IAtomicLong atomicLong) {
        this.vertx = vertx;
        this.atomicLong = atomicLong;
    }

    public void get(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.executeAsync(this.atomicLong.getAsync(), resultHandler);
    }

    public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.executeAsync(this.atomicLong.incrementAndGetAsync(), resultHandler);
    }

    public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.executeAsync(this.atomicLong.getAndIncrementAsync(), resultHandler);
    }

    public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.executeAsync(this.atomicLong.decrementAndGetAsync(), resultHandler);
    }

    public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.executeAsync(this.atomicLong.addAndGetAsync(value), resultHandler);
    }

    public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.executeAsync(this.atomicLong.getAndAddAsync(value), resultHandler);
    }

    public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.executeAsync(this.atomicLong.compareAndSetAsync(expected, value), resultHandler);
    }

    private <T> void executeAsync(ICompletableFuture<T> future, Handler<AsyncResult<T>> resultHandler) {
        future.andThen(new HandlerCallBackAdapter<T>(resultHandler), (Executor)VertxExecutorAdapter.getOrCreate(this.vertx.getOrCreateContext()));
    }
}

