/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler;

import io.vertx.lang.groovy.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ClasspathFinder;
import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanSpec;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import java.net.URL;
import java.net.URLClassLoader;

public class URLClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"java.net.URLClassLoader"};

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ClassLoader classLoader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) {
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        if (urls != null) {
            for (URL url : urls) {
                if (url == null) continue;
                classpathFinder.addClasspathElement(url.toString(), classLoader, log);
            }
        }
    }
}

