/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.groovy.rabbitmq;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.ConversionHelper;
import io.vertx.core.json.JsonObject;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQClient;
import io.vertx.rabbitmq.RabbitMQConsumer;
import java.util.Map;
import java.util.stream.Collectors;

public class RabbitMQClient_GroovyExtension {
    public static void basicAck(RabbitMQClient j_receiver, long deliveryTag, boolean multiple, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.basicAck(deliveryTag, multiple, (Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void basicNack(RabbitMQClient j_receiver, long deliveryTag, boolean multiple, boolean requeue, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.basicNack(deliveryTag, multiple, requeue, (Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void basicGet(RabbitMQClient j_receiver, String queue, boolean autoAck, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.basicGet(queue, autoAck, (Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void basicConsumer(RabbitMQClient j_receiver, String queue, Map<String, Object> options, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        j_receiver.basicConsumer(queue, options != null ? new QueueOptions(ConversionHelper.toJsonObject(options)) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<RabbitMQConsumer>>(){

            public void handle(AsyncResult<RabbitMQConsumer> ar) {
                resultHandler.handle((Object)ar.map(event -> (RabbitMQConsumer)ConversionHelper.fromObject((Object)event)));
            }
        } : null));
    }

    public static void basicPublish(RabbitMQClient j_receiver, String exchange, String routingKey, Map<String, Object> message, final Handler<AsyncResult<Void>> resultHandler) {
        j_receiver.basicPublish(exchange, routingKey, message != null ? ConversionHelper.toJsonObject(message) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                resultHandler.handle((Object)ar.map(event -> (Void)ConversionHelper.fromObject((Object)event)));
            }
        } : null));
    }

    public static void exchangeDeclare(RabbitMQClient j_receiver, String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> config, final Handler<AsyncResult<Void>> resultHandler) {
        j_receiver.exchangeDeclare(exchange, type, durable, autoDelete, config != null ? ConversionHelper.toJsonObject(config) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                resultHandler.handle((Object)ar.map(event -> (Void)ConversionHelper.fromObject((Object)event)));
            }
        } : null));
    }

    public static void exchangeBind(RabbitMQClient j_receiver, String destination, String source, String routingKey, Map<String, Object> arguments, final Handler<AsyncResult<Void>> resultHandler) {
        j_receiver.exchangeBind(destination, source, routingKey, arguments != null ? arguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ConversionHelper.toObject(entry.getValue()))) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                resultHandler.handle((Object)ar.map(event -> (Void)ConversionHelper.fromObject((Object)event)));
            }
        } : null));
    }

    public static void exchangeUnbind(RabbitMQClient j_receiver, String destination, String source, String routingKey, Map<String, Object> arguments, final Handler<AsyncResult<Void>> resultHandler) {
        j_receiver.exchangeUnbind(destination, source, routingKey, arguments != null ? arguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ConversionHelper.toObject(entry.getValue()))) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                resultHandler.handle((Object)ar.map(event -> (Void)ConversionHelper.fromObject((Object)event)));
            }
        } : null));
    }

    public static void queueDeclareAuto(RabbitMQClient j_receiver, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeclareAuto((Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void queueDeclare(RabbitMQClient j_receiver, String queue, boolean durable, boolean exclusive, boolean autoDelete, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeclare(queue, durable, exclusive, autoDelete, (Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void queueDeclare(RabbitMQClient j_receiver, String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> config, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeclare(queue, durable, exclusive, autoDelete, config != null ? ConversionHelper.toJsonObject(config) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void queueDelete(RabbitMQClient j_receiver, String queue, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDelete(queue, (Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void queueDeleteIf(RabbitMQClient j_receiver, String queue, boolean ifUnused, boolean ifEmpty, final Handler<AsyncResult<Map<String, Object>>> resultHandler) {
        j_receiver.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler)(resultHandler != null ? new Handler<AsyncResult<JsonObject>>(){

            public void handle(AsyncResult<JsonObject> ar) {
                resultHandler.handle((Object)ar.map(event -> ConversionHelper.fromJsonObject((JsonObject)event)));
            }
        } : null));
    }

    public static void queueBind(RabbitMQClient j_receiver, String queue, String exchange, String routingKey, Map<String, Object> arguments, final Handler<AsyncResult<Void>> resultHandler) {
        j_receiver.queueBind(queue, exchange, routingKey, arguments != null ? arguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ConversionHelper.toObject(entry.getValue()))) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                resultHandler.handle((Object)ar.map(event -> (Void)ConversionHelper.fromObject((Object)event)));
            }
        } : null));
    }

    public static void queueUnbind(RabbitMQClient j_receiver, String queue, String exchange, String routingKey, Map<String, Object> arguments, final Handler<AsyncResult<Void>> resultHandler) {
        j_receiver.queueUnbind(queue, exchange, routingKey, arguments != null ? arguments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ConversionHelper.toObject(entry.getValue()))) : null, (Handler)(resultHandler != null ? new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                resultHandler.handle((Object)ar.map(event -> (Void)ConversionHelper.fromObject((Object)event)));
            }
        } : null));
    }
}

