require 'vertx-web-common/form_data_part'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.multipart.MultipartForm
module VertxWebCommon
  #  A multipart form.
  class MultipartForm
    # @private
    # @param j_del [::VertxWebCommon::MultipartForm] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebCommon::MultipartForm] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MultipartForm
    end
    def @@j_api_type.wrap(obj)
      MultipartForm.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebMultipart::MultipartForm.java_class
    end
    # @return [::VertxWebCommon::MultipartForm] a multipart form instance
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebMultipart::MultipartForm.java_method(:create, []).call(),::VertxWebCommon::MultipartForm)
      end
      raise ArgumentError, "Invalid arguments when calling create()"
    end
    #  Add an attribute form data part.
    # @param [String] name the name of the attribute
    # @param [String] value the value of the attribute
    # @return [self]
    def attribute(name=nil,value=nil)
      if name.class == String && value.class == String && !block_given?
        @j_del.java_method(:attribute, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(name,value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling attribute(#{name},#{value})"
    end
    #  Add a text file upload form data part.
    # @param [String] name name of the parameter
    # @param [String] filename filename of the file
    # @param [String] pathname the pathname of the file
    # @param [String] mediaType the MIME type of the file
    # @return [self]
    def text_file_upload(name=nil,filename=nil,pathname=nil,mediaType=nil)
      if name.class == String && filename.class == String && pathname.class == String && mediaType.class == String && !block_given?
        @j_del.java_method(:textFileUpload, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(name,filename,pathname,mediaType)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling text_file_upload(#{name},#{filename},#{pathname},#{mediaType})"
    end
    #  Add a binary file upload form data part.
    # @param [String] name name of the parameter
    # @param [String] filename filename of the file
    # @param [String] pathname the pathname of the file
    # @param [String] mediaType the MIME type of the file
    # @return [self]
    def binary_file_upload(name=nil,filename=nil,pathname=nil,mediaType=nil)
      if name.class == String && filename.class == String && pathname.class == String && mediaType.class == String && !block_given?
        @j_del.java_method(:binaryFileUpload, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(name,filename,pathname,mediaType)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling binary_file_upload(#{name},#{filename},#{pathname},#{mediaType})"
    end
  end
end
