require 'vertx/pipe'
require 'vertx-kafka-client/kafka_consumer_record'
require 'vertx/write_stream'
require 'vertx/vertx'
require 'vertx/read_stream'
require 'vertx-kafka-client/kafka_consumer_records'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.client.consumer.KafkaConsumer
module VertxKafkaClient
  #  Vert.x Kafka consumer.
  #  <p>
  #  You receive Kafka records by providing a {::VertxKafkaClient::KafkaConsumer#handler}. As messages arrive the handler
  #  will be called with the records.
  #  <p>
  #  The {::VertxKafkaClient::KafkaConsumer#pause} and {::VertxKafkaClient::KafkaConsumer#resume} provides global control over reading the records from the consumer.
  #  <p>
  #  The {::VertxKafkaClient::KafkaConsumer#pause} and {::VertxKafkaClient::KafkaConsumer#resume} provides finer grained control over reading records
  #  for specific Topic/Partition, these are Kafka's specific operations.
  class KafkaConsumer
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxKafkaClient::KafkaConsumer] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxKafkaClient::KafkaConsumer] the underlying java delegate
    def j_del
      @j_del
    end
    #  Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
    #  recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
    #  be added to the current stream demand.
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::VertxKafkaClient::KafkaConsumerRecord.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class]).call(dst.j_del)
      elsif dst.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    #  Create a new KafkaConsumer instance
    # @param [::Vertx::Vertx] vertx Vert.x instance to use
    # @param [Hash{String => String}] config Kafka consumer configuration
    # @param [Nil] keyType class type for the key deserialization
    # @param [Nil] valueType class type for the value deserialization
    # @return [::VertxKafkaClient::KafkaConsumer] an instance of the KafkaConsumer
    def self.create(vertx=nil,config=nil,keyType=nil,valueType=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && !block_given? && keyType == nil && valueType == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientConsumer::KafkaConsumer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class]).call(vertx.j_del,Hash[config.map { |k,v| [k,v] }]),::VertxKafkaClient::KafkaConsumer, nil, nil)
      elsif vertx.class.method_defined?(:j_del) && config.class == Hash && keyType.class == Class && valueType.class == Class && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientConsumer::KafkaConsumer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class,Java::JavaLang::Class.java_class,Java::JavaLang::Class.java_class]).call(vertx.j_del,Hash[config.map { |k,v| [k,v] }],::Vertx::Util::Utils.j_class_of(keyType),::Vertx::Util::Utils.j_class_of(valueType)),::VertxKafkaClient::KafkaConsumer, ::Vertx::Util::Utils.v_type_of(keyType), ::Vertx::Util::Utils.v_type_of(valueType))
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{config},#{keyType},#{valueType})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxKafkaClient::KafkaConsumerRecord, nil, nil)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    #  Suspend fetching from the requested partitions.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages from the given <code>topicPartitions</code>
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will not see messages
    #  from the given <code>topicPartitions</code>.
    # @overload pause()
    # @overload pause(topicPartition)
    #   @param [Hash] topicPartition topic partition from which suspend fetching
    # @overload pause(topicPartitions)
    #   @param [Set<Hash>] topicPartitions topic partition from which suspend fetching
    # @overload pause(topicPartition,completionHandler)
    #   @param [Hash] topicPartition topic partition from which suspend fetching
    #   @yield handler called on operation completed
    # @overload pause(topicPartitions,completionHandler)
    #   @param [Set<Hash>] topicPartitions topic partition from which suspend fetching
    #   @yield handler called on operation completed
    # @return [self]
    def pause(param_1=nil)
      if !block_given? && param_1 == nil
        @j_del.java_method(:pause, []).call()
        return self
      elsif param_1.class == Hash && !block_given?
        @j_del.java_method(:pause, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)))
        return self
      elsif param_1.class == Set && !block_given?
        @j_del.java_method(:pause, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }))
        return self
      elsif param_1.class == Hash && block_given?
        @j_del.java_method(:pause, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif param_1.class == Set && block_given?
        @j_del.java_method(:pause, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause(#{param_1})"
    end
    #  Resume specified partitions which have been paused with pause.
    # @overload resume()
    # @overload resume(topicPartition)
    #   @param [Hash] topicPartition topic partition from which resume fetching
    # @overload resume(topicPartitions)
    #   @param [Set<Hash>] topicPartitions topic partition from which resume fetching
    # @overload resume(topicPartition,completionHandler)
    #   @param [Hash] topicPartition topic partition from which resume fetching
    #   @yield handler called on operation completed
    # @overload resume(topicPartitions,completionHandler)
    #   @param [Set<Hash>] topicPartitions topic partition from which resume fetching
    #   @yield handler called on operation completed
    # @return [self]
    def resume(param_1=nil)
      if !block_given? && param_1 == nil
        @j_del.java_method(:resume, []).call()
        return self
      elsif param_1.class == Hash && !block_given?
        @j_del.java_method(:resume, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)))
        return self
      elsif param_1.class == Set && !block_given?
        @j_del.java_method(:resume, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }))
        return self
      elsif param_1.class == Hash && block_given?
        @j_del.java_method(:resume, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif param_1.class == Set && block_given?
        @j_del.java_method(:resume, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume(#{param_1})"
    end
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    #  Subscribe to the given list of topics to get dynamically assigned partitions.
    #  <p>
    #  Due to internal buffering of messages, when changing the subscribed topics
    #  the old set of topics may remain in effect
    #  (as observed by the  record handler})
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new set of topics.
    # @overload subscribe(topic)
    #   @param [String] topic topic to subscribe to
    # @overload subscribe(topics)
    #   @param [Set<String>] topics topics to subscribe to
    # @overload subscribe(topic,completionHandler)
    #   @param [String] topic topic to subscribe to
    #   @yield handler called on operation completed
    # @overload subscribe(topics,completionHandler)
    #   @param [Set<String>] topics topics to subscribe to
    #   @yield handler called on operation completed
    # @return [self]
    def subscribe(param_1=nil)
      if param_1.class == String && !block_given?
        @j_del.java_method(:subscribe, [Java::java.lang.String.java_class]).call(param_1)
        return self
      elsif param_1.class == Set && !block_given?
        @j_del.java_method(:subscribe, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| element }))
        return self
      elsif param_1.class == String && block_given?
        @j_del.java_method(:subscribe, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif param_1.class == Set && block_given?
        @j_del.java_method(:subscribe, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| element }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling subscribe(#{param_1})"
    end
    #  Manually assign a list of partition to this consumer.
    #  <p>
    #  Due to internal buffering of messages, when reassigning
    #  the old set of partitions may remain in effect
    #  (as observed by the  record handler)}
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new set of partitions.
    # @overload assign(topicPartition)
    #   @param [Hash] topicPartition partition which want assigned
    # @overload assign(topicPartitions)
    #   @param [Set<Hash>] topicPartitions partitions which want assigned
    # @overload assign(topicPartition,completionHandler)
    #   @param [Hash] topicPartition partition which want assigned
    #   @yield handler called on operation completed
    # @overload assign(topicPartitions,completionHandler)
    #   @param [Set<Hash>] topicPartitions partitions which want assigned
    #   @yield handler called on operation completed
    # @return [self]
    def assign(param_1=nil)
      if param_1.class == Hash && !block_given?
        @j_del.java_method(:assign, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)))
        return self
      elsif param_1.class == Set && !block_given?
        @j_del.java_method(:assign, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }))
        return self
      elsif param_1.class == Hash && block_given?
        @j_del.java_method(:assign, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif param_1.class == Set && block_given?
        @j_del.java_method(:assign, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling assign(#{param_1})"
    end
    #  Get the set of partitions currently assigned to this consumer.
    # @yield handler called on operation completed
    # @return [self]
    def assignment
      if block_given?
        @j_del.java_method(:assignment, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling assignment()"
    end
    #  Unsubscribe from topics currently subscribed with subscribe.
    # @yield handler called on operation completed
    # @return [self]
    def unsubscribe
      if !block_given?
        @j_del.java_method(:unsubscribe, []).call()
        return self
      elsif block_given?
        @j_del.java_method(:unsubscribe, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling unsubscribe()"
    end
    #  Get the current subscription.
    # @yield handler called on operation completed
    # @return [self]
    def subscription
      if block_given?
        @j_del.java_method(:subscription, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt } : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling subscription()"
    end
    #  Get the set of partitions that were previously paused by a call to pause(Set).
    # @yield handler called on operation completed
    # @return [void]
    def paused
      if block_given?
        return @j_del.java_method(:paused, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.to_set(ar.result).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling paused()"
    end
    #  Set the handler called when topic partitions are revoked to the consumer
    # @yield handler called on revoked topic partitions
    # @return [self]
    def partitions_revoked_handler
      if block_given?
        @j_del.java_method(:partitionsRevokedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.to_set(event).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil }) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling partitions_revoked_handler()"
    end
    #  Set the handler called when topic partitions are assigned to the consumer
    # @yield handler called on assigned topic partitions
    # @return [self]
    def partitions_assigned_handler
      if block_given?
        @j_del.java_method(:partitionsAssignedHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.to_set(event).map! { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil }) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling partitions_assigned_handler()"
    end
    #  Overrides the fetch offsets that the consumer will use on the next poll.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages fetched with respect to the old offset
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new offset.
    # @param [Hash] topicPartition topic partition for which seek
    # @param [Fixnum] offset offset to seek inside the topic partition
    # @yield handler called on operation completed
    # @return [self]
    def seek(topicPartition=nil,offset=nil)
      if topicPartition.class == Hash && offset.class == Fixnum && !block_given?
        @j_del.java_method(:seek, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::long.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(topicPartition)),offset)
        return self
      elsif topicPartition.class == Hash && offset.class == Fixnum && block_given?
        @j_del.java_method(:seek, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(topicPartition)),offset,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling seek(#{topicPartition},#{offset})"
    end
    #  Seek to the first offset for each of the given partitions.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages fetched with respect to the old offset
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new offset.
    # @overload seekToBeginning(topicPartition)
    #   @param [Hash] topicPartition topic partition for which seek
    # @overload seekToBeginning(topicPartitions)
    #   @param [Set<Hash>] topicPartitions topic partition for which seek
    # @overload seekToBeginning(topicPartition,completionHandler)
    #   @param [Hash] topicPartition topic partition for which seek
    #   @yield handler called on operation completed
    # @overload seekToBeginning(topicPartitions,completionHandler)
    #   @param [Set<Hash>] topicPartitions topic partition for which seek
    #   @yield handler called on operation completed
    # @return [self]
    def seek_to_beginning(param_1=nil)
      if param_1.class == Hash && !block_given?
        @j_del.java_method(:seekToBeginning, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)))
        return self
      elsif param_1.class == Set && !block_given?
        @j_del.java_method(:seekToBeginning, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }))
        return self
      elsif param_1.class == Hash && block_given?
        @j_del.java_method(:seekToBeginning, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif param_1.class == Set && block_given?
        @j_del.java_method(:seekToBeginning, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling seek_to_beginning(#{param_1})"
    end
    #  Seek to the last offset for each of the given partitions.
    #  <p>
    #  Due to internal buffering of messages,
    #  the  will
    #  continue to observe messages fetched with respect to the old offset
    #  until some time <em>after</em> the given <code>completionHandler</code>
    #  is called. In contrast, the once the given <code>completionHandler</code>
    #  is called the {::VertxKafkaClient::KafkaConsumer#batch_handler} will only see messages
    #  consistent with the new offset.
    # @overload seekToEnd(topicPartition)
    #   @param [Hash] topicPartition topic partition for which seek
    # @overload seekToEnd(topicPartitions)
    #   @param [Set<Hash>] topicPartitions topic partition for which seek
    # @overload seekToEnd(topicPartition,completionHandler)
    #   @param [Hash] topicPartition topic partition for which seek
    #   @yield handler called on operation completed
    # @overload seekToEnd(topicPartitions,completionHandler)
    #   @param [Set<Hash>] topicPartitions topic partition for which seek
    #   @yield handler called on operation completed
    # @return [self]
    def seek_to_end(param_1=nil)
      if param_1.class == Hash && !block_given?
        @j_del.java_method(:seekToEnd, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)))
        return self
      elsif param_1.class == Set && !block_given?
        @j_del.java_method(:seekToEnd, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }))
        return self
      elsif param_1.class == Hash && block_given?
        @j_del.java_method(:seekToEnd, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(param_1)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif param_1.class == Set && block_given?
        @j_del.java_method(:seekToEnd, [Java::JavaUtil::Set.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::JavaUtil::LinkedHashSet.new(param_1.map { |element| Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(element)) }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling seek_to_end(#{param_1})"
    end
    #  Commit current offsets for all the subscribed list of topics and partition.
    # @yield handler called on operation completed
    # @return [void]
    def commit
      if !block_given?
        return @j_del.java_method(:commit, []).call()
      elsif block_given?
        return @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling commit()"
    end
    #  Get the last committed offset for the given partition (whether the commit happened by this process or another).
    # @param [Hash] topicPartition topic partition for getting last committed offset
    # @yield handler called on operation completed
    # @return [void]
    def committed(topicPartition=nil)
      if topicPartition.class == Hash && block_given?
        return @j_del.java_method(:committed, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(topicPartition)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling committed(#{topicPartition})"
    end
    #  Get metadata about the partitions for a given topic.
    # @param [String] topic topic partition for which getting partitions info
    # @yield handler called on operation completed
    # @return [self]
    def partitions_for(topic=nil)
      if topic.class == String && block_given?
        @j_del.java_method(:partitionsFor, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(topic,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling partitions_for(#{topic})"
    end
    #  Set the handler to be used when batches of messages are fetched
    #  from the Kafka server. Batch handlers need to take care not to block
    #  the event loop when dealing with large batches. It is better to process
    #  records individually using the {::VertxKafkaClient::KafkaConsumer#handler(Handler) record handler}.
    # @yield handler called when batches of messages are fetched
    # @return [self]
    def batch_handler
      if block_given?
        @j_del.java_method(:batchHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxKafkaClient::KafkaConsumerRecords, nil, nil)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling batch_handler()"
    end
    #  Close the consumer
    # @yield handler called on operation completed
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Get the offset of the next record that will be fetched (if a record with that offset exists).
    # @param [Hash] partition The partition to get the position for
    # @yield handler called on operation completed
    # @return [void]
    def position(partition=nil)
      if partition.class == Hash && block_given?
        return @j_del.java_method(:position, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(partition)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling position(#{partition})"
    end
    #  Look up the offset for the given partition by timestamp. Note: the result might be null in case
    #  for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
    # @param [Hash] topicPartition TopicPartition to query.
    # @param [Fixnum] timestamp Timestamp to be used in the query.
    # @yield handler called on operation completed
    # @return [void]
    def offsets_for_times(topicPartition=nil,timestamp=nil)
      if topicPartition.class == Hash && timestamp.class == Fixnum && block_given?
        return @j_del.java_method(:offsetsForTimes, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::JavaLang::Long.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(topicPartition)),timestamp,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling offsets_for_times(#{topicPartition},#{timestamp})"
    end
    #  Get the first offset for the given partitions.
    # @param [Hash] topicPartition the partition to get the earliest offset.
    # @yield handler called on operation completed. Returns the earliest available offset for the given partition
    # @return [void]
    def beginning_offsets(topicPartition=nil)
      if topicPartition.class == Hash && block_given?
        return @j_del.java_method(:beginningOffsets, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(topicPartition)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling beginning_offsets(#{topicPartition})"
    end
    #  Get the last offset for the given partition. The last offset of a partition is the offset
    #  of the upcoming message, i.e. the offset of the last available message + 1.
    # @param [Hash] topicPartition the partition to get the end offset.
    # @yield handler called on operation completed. The end offset for the given partition.
    # @return [void]
    def end_offsets(topicPartition=nil)
      if topicPartition.class == Hash && block_given?
        return @j_del.java_method(:endOffsets, [Java::IoVertxKafkaClientCommon::TopicPartition.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxKafkaClientCommon::TopicPartition.new(::Vertx::Util::Utils.to_json_object(topicPartition)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling end_offsets(#{topicPartition})"
    end
    #  Sets the poll timeout (in ms) for the underlying native Kafka Consumer. Defaults to 1000.
    #  Setting timeout to a lower value results in a more 'responsive' client, because it will block for a shorter period
    #  if no data is available in the assigned partition and therefore allows subsequent actions to be executed with a shorter
    #  delay. At the same time, the client will poll more frequently and thus will potentially create a higher load on the Kafka Broker.
    # @param [Fixnum] timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
    # @return [::VertxKafkaClient::KafkaConsumer]
    def poll_timeout(timeout=nil)
      if timeout.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pollTimeout, [Java::long.java_class]).call(timeout),::VertxKafkaClient::KafkaConsumer, nil, nil)
      end
      raise ArgumentError, "Invalid arguments when calling poll_timeout(#{timeout})"
    end
    #  Executes a poll for getting messages from Kafka
    # @param [Fixnum] timeout The time, in milliseconds, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
    # @yield handler called after the poll with batch of records (can be empty).
    # @return [void]
    def poll(timeout=nil)
      if timeout.class == Fixnum && block_given?
        return @j_del.java_method(:poll, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(timeout,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxKafkaClient::KafkaConsumerRecords, nil, nil) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling poll(#{timeout})"
    end
  end
end
