require 'vertx/vertx'
require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.circuitbreaker.HystrixMetricHandler
module VertxCircuitBreaker
  #  A Vert.x web handler to expose the circuit breaker to the Hystrix dasbboard. The handler listens to the circuit
  #  breaker notifications sent on the event bus.
  class HystrixMetricHandler
    # @private
    # @param j_del [::VertxCircuitBreaker::HystrixMetricHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCircuitBreaker::HystrixMetricHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HystrixMetricHandler
    end
    def @@j_api_type.wrap(obj)
      HystrixMetricHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCircuitbreaker::HystrixMetricHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Creates the handler.
    # @param [::Vertx::Vertx] vertx the Vert.x instance
    # @param [String] address the address to listen on the event bus
    # @return [::VertxCircuitBreaker::HystrixMetricHandler] the handler
    def self.create(vertx=nil,address=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && address == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCircuitbreaker::HystrixMetricHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxCircuitBreaker::HystrixMetricHandler)
      elsif vertx.class.method_defined?(:j_del) && address.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCircuitbreaker::HystrixMetricHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(vertx.j_del,address),::VertxCircuitBreaker::HystrixMetricHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{address})"
    end
  end
end
