require 'vertx-auth-oauth2/open_id_connect_auth'
require 'vertx/vertx'
require 'vertx-auth-oauth2/o_auth2_auth'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.providers.SalesforceAuth
module VertxAuthOauth2
  #  Simplified factory to create an  for Salesforce.
  class SalesforceAuth < ::VertxAuthOauth2::OpenIDConnectAuth
    # @private
    # @param j_del [::VertxAuthOauth2::SalesforceAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::SalesforceAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SalesforceAuth
    end
    def @@j_api_type.wrap(obj)
      SalesforceAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Providers::SalesforceAuth.java_class
    end
    #  Create a OAuth2Auth provider for Salesforce
    # @param [::Vertx::Vertx] vertx 
    # @param [String] clientId the client id given to you by Salesforce
    # @param [String] clientSecret the client secret given to you by Salesforce
    # @param [Hash] httpClientOptions custom http client options
    # @return [::VertxAuthOauth2::OAuth2Auth]
    def self.create(vertx=nil,clientId=nil,clientSecret=nil,httpClientOptions=nil)
      if vertx.class.method_defined?(:j_del) && clientId.class == String && clientSecret.class == String && !block_given? && httpClientOptions == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::SalesforceAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(vertx.j_del,clientId,clientSecret),::VertxAuthOauth2::OAuth2Auth)
      elsif vertx.class.method_defined?(:j_del) && clientId.class == String && clientSecret.class == String && httpClientOptions.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::SalesforceAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreHttp::HttpClientOptions.java_class]).call(vertx.j_del,clientId,clientSecret,Java::IoVertxCoreHttp::HttpClientOptions.new(::Vertx::Util::Utils.to_json_object(httpClientOptions))),::VertxAuthOauth2::OAuth2Auth)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{clientId},#{clientSecret},#{httpClientOptions})"
    end
    #  Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
    #  configuration options and attempt to load the well known descriptor. If a site is provided (for example when
    #  running on a custom instance) that site will be used to do the lookup.
    #  <p>
    #  If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
    #  into the OAuth provider so tokens can be decoded.
    # @param [::Vertx::Vertx] vertx the vertx instance
    # @param [Hash] config the initial config
    # @yield the instantiated Oauth2 provider instance handler
    # @return [void]
    def self.discover(vertx=nil,config=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && block_given?
        return Java::IoVertxExtAuthOauth2Providers::SalesforceAuth.java_method(:discover, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(vertx.j_del,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(config)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Auth) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling discover(#{vertx},#{config})"
    end
  end
end
