require 'vertx-auth-oauth2/o_auth2_rbac'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.rbac.MicroProfileRBAC
module VertxAuthOauth2
  #  Implementation of the Microprofile MP-JWT 1.1 RBAC based on the access token groups key.
  class MicroProfileRBAC
    # @private
    # @param j_del [::VertxAuthOauth2::MicroProfileRBAC] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::MicroProfileRBAC] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MicroProfileRBAC
    end
    def @@j_api_type.wrap(obj)
      MicroProfileRBAC.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Rbac::MicroProfileRBAC.java_class
    end
    #  Factory method to create a RBAC handler for tokens adhering to the MP-JWT 1.1 spec.
    # @return [::VertxAuthOauth2::OAuth2RBAC] a RBAC validator
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Rbac::MicroProfileRBAC.java_method(:create, []).call(),::VertxAuthOauth2::OAuth2RBAC)
      end
      raise ArgumentError, "Invalid arguments when calling create()"
    end
  end
end
