require 'vertx-auth-common/hashing_algorithm'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.HashingStrategy
module VertxAuthCommon
  #  Hashing Strategy manager.
  # 
  #  This class will load system provided hashing strategies and algorithms.
  class HashingStrategy
    # @private
    # @param j_del [::VertxAuthCommon::HashingStrategy] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthCommon::HashingStrategy] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HashingStrategy
    end
    def @@j_api_type.wrap(obj)
      HashingStrategy.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuth::HashingStrategy.java_class
    end
    #  Factory method to load the algorithms from the system
    # @return [::VertxAuthCommon::HashingStrategy] a Hashing Strategy capable of hashing using the available algorithms
    def self.load
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuth::HashingStrategy.java_method(:load, []).call(),::VertxAuthCommon::HashingStrategy)
      end
      raise ArgumentError, "Invalid arguments when calling load()"
    end
    #  Hashes a password.
    # @param [String] id the algorithm id
    # @param [Hash{String => String}] params the algorithm specific paramters
    # @param [String] salt the given salt
    # @param [String] password the given password
    # @return [String] the hashed string
    def hash(id=nil,params=nil,salt=nil,password=nil)
      if id.class == String && params.class == Hash && salt.class == String && password.class == String && !block_given?
        return @j_del.java_method(:hash, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(id,Hash[params.map { |k,v| [k,v] }],salt,password)
      end
      raise ArgumentError, "Invalid arguments when calling hash(#{id},#{params},#{salt},#{password})"
    end
    #  Time constant password check. Regardless of the check, this algorithm executes the same number of
    #  checks regardless of the correctly number of characters
    # @param [String] hash the hash to verify
    # @param [String] password the password to test against
    # @return [true,false] boolean
    def verify?(hash=nil,password=nil)
      if hash.class == String && password.class == String && !block_given?
        return @j_del.java_method(:verify, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(hash,password)
      end
      raise ArgumentError, "Invalid arguments when calling verify?(#{hash},#{password})"
    end
    #  Get an algorithm interface by its Id
    # @param [String] id the algorithm id
    # @return [::VertxAuthCommon::HashingAlgorithm] the algorithm
    def get(id=nil)
      if id.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:get, [Java::java.lang.String.java_class]).call(id),::VertxAuthCommon::HashingAlgorithm)
      end
      raise ArgumentError, "Invalid arguments when calling get(#{id})"
    end
    #  Put or replace an algorithm into the list of system loaded algorithms.
    # @param [String] id the algorithm id
    # @param [::VertxAuthCommon::HashingAlgorithm] algorithm the implementation
    # @return [self]
    def put(id=nil,algorithm=nil)
      if id.class == String && algorithm.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:put, [Java::java.lang.String.java_class,Java::IoVertxExtAuth::HashingAlgorithm.java_class]).call(id,algorithm.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling put(#{id},#{algorithm})"
    end
  end
end
